/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.commands.features.admin.migrate.types.deprecation;

import com.badbones69.crazyvouchers.Methods;
import com.badbones69.crazyvouchers.api.enums.Comments;
import com.badbones69.crazyvouchers.api.enums.FileKeys;
import com.badbones69.crazyvouchers.api.enums.FileSystem;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.IVoucherMigrator;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.enums.MigrationType;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import libs.com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import libs.com.ryderbelserion.fusion.paper.utils.ItemUtils;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class NewItemMigrator
extends IVoucherMigrator {
    public NewItemMigrator(CommandSender sender) {
        super(sender, MigrationType.NEW_ITEM_FORMAT);
    }

    @Override
    public void run() {
        ArrayList<CallSite> failed = new ArrayList<CallSite>();
        ArrayList<CallSite> success = new ArrayList<CallSite>();
        FileSystem system = this.config.getProperty(ConfigKeys.file_system);
        switch (system) {
            case SINGLE: {
                YamlConfiguration yamlConfiguration;
                ConfigurationSection voucherSection;
                YamlConfiguration codes = FileKeys.codes.getConfiguration();
                ConfigurationSection codeSection = codes.getConfigurationSection("voucher-codes");
                if (codeSection != null) {
                    for (String code : codeSection.getKeys(false)) {
                        ConfigurationSection item = codeSection.getConfigurationSection(code);
                        if (item == null) {
                            this.fusion.log("warn", "Failed to migrate code {}, because section is null.", code);
                            continue;
                        }
                        boolean isSave = this.process(item);
                        if (!isSave) continue;
                        this.fusion.log("info", "Successfully migrated code {}, and saved to file!", code);
                        FileKeys.codes.save();
                    }
                }
                if ((voucherSection = (yamlConfiguration = FileKeys.vouchers.getConfiguration()).getConfigurationSection("vouchers")) == null) break;
                for (String voucher : voucherSection.getKeys(false)) {
                    ConfigurationSection item = voucherSection.getConfigurationSection(voucher);
                    if (item == null) {
                        this.fusion.log("warn", "Failed to migrate voucher {}, because section is null.", voucher);
                        continue;
                    }
                    boolean isSave = this.process(item);
                    if (!isSave) continue;
                    this.fusion.log("info", "Successfully migrated voucher {}, and saved to file!", voucher);
                    FileKeys.vouchers.save();
                }
                break;
            }
            case MULTIPLE: {
                List<Path> vouchers = this.fusion.getFiles(this.getVouchersDirectory(), ".yml");
                for (Path path : vouchers) {
                    Optional<PaperCustomFile> optional = this.fileManager.getPaperFile(path);
                    if (optional.isEmpty()) {
                        this.fusion.log("warn", "Failed to migrate voucher {}, because file does not exist in the cache.", path);
                        continue;
                    }
                    PaperCustomFile customFile = optional.get();
                    try {
                        if (!customFile.isLoaded()) {
                            this.fusion.log("warn", "Failed to migrate voucher {}, because section is null.", path);
                            continue;
                        }
                        YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                        ConfigurationSection section = configuration.getConfigurationSection("voucher");
                        if (section == null) {
                            this.fusion.log("warn", "Failed to migrate voucher {}, because configuration section is null.", path);
                            continue;
                        }
                        boolean isSave = this.process(section);
                        if (isSave) {
                            this.fusion.log("info", "Successfully migrated voucher {}, and saved to file!", path);
                            customFile.save();
                        }
                        success.add((CallSite)((Object)("<green>\u2937 " + customFile.getPrettyName())));
                    }
                    catch (Exception exception) {
                        failed.add((CallSite)((Object)("<red>\u2937 " + customFile.getPrettyName())));
                        exception.printStackTrace();
                    }
                }
                List<Path> codes = this.fusion.getFiles(this.getCodesDirectory(), ".yml");
                for (Path code : codes) {
                    Optional<PaperCustomFile> optional = this.fileManager.getPaperFile(code);
                    if (optional.isEmpty()) {
                        this.fusion.log("warn", "Failed to migrate code {}, because file does not exist in the cache.", code);
                        continue;
                    }
                    PaperCustomFile customFile = optional.get();
                    try {
                        if (!customFile.isLoaded()) {
                            this.fusion.log("warn", "Failed to migrate code {}, because section is null.", code);
                            continue;
                        }
                        YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                        ConfigurationSection section = configuration.getConfigurationSection("voucher-code");
                        if (section == null) {
                            this.fusion.log("warn", "Failed to migrate code {}, because configuration section is null.", code);
                            continue;
                        }
                        boolean isSave = this.process(section);
                        if (isSave) {
                            this.fusion.log("info", "Successfully migrated code {}, and saved to file!", code);
                            customFile.save();
                        }
                        success.add((CallSite)((Object)("<green>\u2937 " + customFile.getPrettyName())));
                    }
                    catch (Exception exception) {
                        failed.add((CallSite)((Object)("<red>\u2937 " + customFile.getPrettyName())));
                    }
                }
                break;
            }
        }
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        ArrayList<String> arrayList = new ArrayList<String>(failedCrates + convertedCrates);
        arrayList.addAll(failed);
        arrayList.addAll(success);
        this.sendMessage(arrayList, convertedCrates, failedCrates);
        this.crazyManager.load(true);
    }

    @Override
    public <T> void set(@NotNull ConfigurationSection section, @NotNull String path, @NotNull T value) {
        section.set(path, value);
    }

    private boolean process(ConfigurationSection section) {
        boolean isSave = false;
        for (String value : section.getKeys(false)) {
            ConfigurationSection prizeSection = section.getConfigurationSection(value);
            if (prizeSection == null || !prizeSection.isList("items")) continue;
            List items = prizeSection.getStringList("items");
            prizeSection.set("items", null);
            items.forEach(item -> {
                HashMap<String, String> patterns = new HashMap<String, String>();
                HashMap<String, Integer> enchantments = new HashMap<String, Integer>();
                String uuid = Methods.randomUUID();
                block44: for (String key : item.split(", ")) {
                    String option = key.split(":")[0];
                    String type = key.replace(option + ":", "").replace(option, "");
                    switch (option.toLowerCase()) {
                        case "item": {
                            prizeSection.set("items." + uuid + ".material", (Object)type);
                            prizeSection.setComments("items." + uuid + ".Material", Comments.material.getComments());
                            continue block44;
                        }
                        case "data": {
                            prizeSection.set("items." + uuid + ".data", (Object)type);
                            prizeSection.setComments("items." + uuid + ".data", Comments.base64.getComments());
                            continue block44;
                        }
                        case "name": {
                            prizeSection.set("items." + uuid + ".name", (Object)type);
                            prizeSection.setComments("items." + uuid + ".name", Comments.name.getComments());
                            continue block44;
                        }
                        case "mob": {
                            prizeSection.set("items." + uuid + ".settings.mob.type", (Object)type);
                            prizeSection.setComments("items." + uuid + ".settings.mob.type", Comments.mob_type.getComments());
                            continue block44;
                        }
                        case "glowing": {
                            prizeSection.set("items." + uuid + ".settings.glowing", (Object)type);
                            prizeSection.setComments("items." + uuid + ".settings.glowing", Comments.glowing.getComments());
                            continue block44;
                        }
                        case "amount": {
                            prizeSection.set("items." + uuid + ".amount", (Object)type);
                            prizeSection.setComments("items." + uuid + ".amount", Comments.amount.getComments());
                            continue block44;
                        }
                        case "damage": {
                            prizeSection.set("items." + uuid + ".settings.damage", (Object)type);
                            prizeSection.setComments("items." + uuid + ".settings.damage", Comments.damage.getComments());
                            continue block44;
                        }
                        case "lore": {
                            prizeSection.set("items." + uuid + ".lore", List.of(type.split(",")));
                            prizeSection.setComments("items." + uuid + ".lore", Comments.lore.getComments());
                            continue block44;
                        }
                        case "player": {
                            prizeSection.set("items." + uuid + ".settings.player", (Object)type);
                            prizeSection.setComments("items." + uuid + ".settings.player", Comments.player.getComments());
                            continue block44;
                        }
                        case "skull": {
                            prizeSection.set("items." + uuid + ".settings.skull", (Object)type);
                            prizeSection.setComments("items." + uuid + ".settings.skull", Comments.skull.getComments());
                            continue block44;
                        }
                        case "custom-model-data": {
                            prizeSection.set("items." + uuid + ".custom-model-data", (Object)type);
                            prizeSection.setComments("items." + uuid + ".custom-model-data", Comments.custom_model_data.getComments());
                            continue block44;
                        }
                        case "unbreakable-item": {
                            prizeSection.set("items." + uuid + ".unbreakable-item", (Object)type);
                            prizeSection.setComments("items." + uuid + ".unbreakable-item", Comments.unbreakable.getComments());
                            continue block44;
                        }
                        case "hide-tool-tip": {
                            prizeSection.set("items." + uuid + ".hide-tool-tip", (Object)type);
                            prizeSection.setComments("items." + uuid + ".hide-tool-tip", Comments.hide_tool_tip.getComments());
                            continue block44;
                        }
                        case "trim-pattern": {
                            prizeSection.set("items." + uuid + ".settings.trim.pattern", (Object)type);
                            prizeSection.setComments("items." + uuid + ".trim.pattern", Comments.trim_pattern.getComments());
                            continue block44;
                        }
                        case "trim-material": {
                            prizeSection.set("items." + uuid + ".settings.trim.material", (Object)type);
                            prizeSection.setComments("items." + uuid + ".settings.trim.material", Comments.trim_material.getComments());
                            continue block44;
                        }
                        case "trim": {
                            String[] split = type.split("!");
                            String trim = split[0];
                            String material = split[1];
                            prizeSection.set("items." + uuid + ".settings.trim.pattern", (Object)trim);
                            prizeSection.setComments("items." + uuid + ".trim.pattern", Comments.trim_pattern.getComments());
                            prizeSection.set("items." + uuid + ".settings.trim.material", (Object)material);
                            prizeSection.setComments("items." + uuid + ".settings.trim.material", Comments.trim_material.getComments());
                            continue block44;
                        }
                        case "rgb": {
                            prizeSection.set("items." + uuid + ".settings.rgb", (Object)type);
                            prizeSection.setComments("items." + uuid + ".settings.rgb", Comments.rgb.getComments());
                            continue block44;
                        }
                        case "color": {
                            prizeSection.set("items." + uuid + ".settings.color", (Object)type);
                            prizeSection.setComments("items." + uuid + ".settings.color", Comments.color.getComments());
                            continue block44;
                        }
                        default: {
                            String placeholder = option.toLowerCase();
                            try {
                                PotionEffectType effect = ItemUtils.getPotionEffect(placeholder);
                                if (effect != null) {
                                    ConfigurationSection potionsSection = prizeSection.createSection("items." + uuid + ".settings.potions");
                                    ConfigurationSection potionSection = potionsSection.createSection(placeholder);
                                    potionSection.set("duration", (Object)60);
                                    potionSection.set("level", (Object)1);
                                    potionSection.set("style.icon", (Object)true);
                                    potionSection.set("style.ambient", (Object)true);
                                    potionSection.set("style.particles", (Object)true);
                                    prizeSection.set("items." + uuid + ".settings.potions", Comments.potions.getComments());
                                }
                            }
                            catch (Exception effect) {
                                // empty catch block
                            }
                            if (ItemUtils.getEnchantment(placeholder) != null) {
                                enchantments.put(option.toLowerCase(), this.utils.tryParseInt(value).map(Number::intValue).orElse(1));
                                ConfigurationSection enchantmentSection = prizeSection.createSection("items." + uuid + ".enchantments");
                                prizeSection.setComments("items." + uuid + ".enchantments", Comments.enchantments.getComments());
                                enchantments.forEach((arg_0, arg_1) -> ((ConfigurationSection)enchantmentSection).set(arg_0, arg_1));
                                continue block44;
                            }
                            if (!prizeSection.contains("items." + uuid + ".hide-tool-tip")) {
                                for (ItemFlag itemFlag : ItemFlag.values()) {
                                    if (!itemFlag.name().equalsIgnoreCase(option)) continue;
                                    prizeSection.set("items." + uuid + ".hide-tool-tip", (Object)true);
                                    prizeSection.setComments("items." + uuid + ".hide-tool-tip", Comments.hide_tool_tip.getComments());
                                    break;
                                }
                            }
                            try {
                                PatternType patternType = ItemUtils.getPatternType(placeholder);
                                if (patternType == null) continue block44;
                                patterns.put(placeholder, type);
                                ConfigurationSection patternsSection = prizeSection.createSection("items." + uuid + ".settings.patterns");
                                prizeSection.setComments("items." + uuid + ".settings.patterns", Comments.patterns.getComments());
                                patterns.forEach((arg_0, arg_1) -> ((ConfigurationSection)patternsSection).set(arg_0, arg_1));
                                continue block44;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
            isSave = true;
        }
        return isSave;
    }
}

