/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.commands.features.admin.migrate.types.deprecation;

import com.badbones69.crazyvouchers.api.enums.FileKeys;
import com.badbones69.crazyvouchers.api.enums.config.Messages;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.IVoucherMigrator;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.enums.MigrationType;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import libs.com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class LegacyColorMigrator
extends IVoucherMigrator {
    public LegacyColorMigrator(@NotNull CommandSender sender) {
        super(sender, MigrationType.VOUCHERS_COLOR);
    }

    @Override
    public void run() {
        ArrayList<Object> failed = new ArrayList<Object>();
        ArrayList<Object> success = new ArrayList<Object>();
        try {
            this.config.setProperty(ConfigKeys.command_prefix, this.utils.convertLegacy(this.config.getProperty(ConfigKeys.command_prefix), true));
            this.config.setProperty(ConfigKeys.dupe_protection_warning, this.utils.convertLegacy(this.config.getProperty(ConfigKeys.dupe_protection_warning), true));
            success.add("<green>\u2937 config.yml");
            this.config.save();
            this.config.reload();
        }
        catch (Exception exception) {
            failed.add("<red>\u2937 config.yml");
        }
        try {
            for (Messages message : Messages.values()) {
                message.migrate();
            }
            success.add("<green>\u2937 messages.yml");
            this.messages.save();
            this.messages.reload();
        }
        catch (Exception exception) {
            failed.add("<red>\u2937 messages.yml");
        }
        switch (this.config.getProperty(ConfigKeys.file_system)) {
            case SINGLE: {
                YamlConfiguration vouchers = FileKeys.vouchers.getConfiguration();
                ConfigurationSection voucherSection = vouchers.getConfigurationSection("vouchers");
                if (voucherSection != null) {
                    for (String key : voucherSection.getKeys(false)) {
                        ConfigurationSection voucher = voucherSection.getConfigurationSection(key);
                        if (voucher == null) continue;
                        this.processItems(key, voucher);
                    }
                    success.add("<green>\u2937 vouchers.yml");
                    FileKeys.vouchers.save();
                } else {
                    this.fusion.log("warn", "Failed to migrate vouchers.yml due to the configuration section being null.", new Object[0]);
                    failed.add("<red>\u2937 vouchers.yml");
                }
                YamlConfiguration codes = FileKeys.codes.getConfiguration();
                ConfigurationSection codeSection = codes.getConfigurationSection("voucher-codes");
                if (codeSection != null) {
                    this.process(codeSection);
                    success.add("<green>\u2937 codes.yml");
                    FileKeys.codes.save();
                    break;
                }
                this.fusion.log("warn", "Failed to migrate codes.yml due to the configuration section being null.", new Object[0]);
                failed.add("<red>\u2937 codes.yml");
                break;
            }
            case MULTIPLE: {
                Path code_dir = this.dataPath.resolve("codes");
                List<Path> code_files = this.fusion.getFiles(code_dir, ".yml");
                for (Path path : code_files) {
                    Optional<PaperCustomFile> optional = this.fileManager.getPaperFile(path);
                    String fileName = path.getFileName().toString();
                    if (optional.isEmpty()) {
                        this.fusion.log("warn", "<red>{}</red> does not exist in the file cache", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    PaperCustomFile customFile = optional.get();
                    if (!customFile.isLoaded()) {
                        this.fusion.log("warn", "<red>{}</red> configuration is invalid, likely not loaded properly. Please check console :)", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                    ConfigurationSection section = configuration.getConfigurationSection("voucher-code");
                    if (section == null) {
                        this.fusion.log("warn", "Configuration section for <red>{}</red> was not found.", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    this.process(section);
                    success.add("<green>\u2937 " + fileName);
                    customFile.save();
                }
                Path voucher_dir = this.dataPath.resolve("vouchers");
                List<Path> voucher_files = this.fusion.getFiles(voucher_dir, ".yml");
                for (Path path : voucher_files) {
                    Optional<PaperCustomFile> optional = this.fileManager.getPaperFile(path);
                    String fileName = path.getFileName().toString();
                    if (optional.isEmpty()) {
                        this.fusion.log("warn", "<red>{}</red> does not exist in the file cache", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    PaperCustomFile customFile = optional.get();
                    if (!customFile.isLoaded()) {
                        this.fusion.log("warn", "<red>{}</red> configuration is invalid, likely not loaded properly. Please check console :)", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                    ConfigurationSection section = configuration.getConfigurationSection("voucher");
                    if (section == null) {
                        this.fusion.log("warn", "Configuration section for <red>{}</red> was not found.", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    this.processItems(customFile.getPrettyName(), section);
                    success.add("<green>\u2937 " + fileName);
                    customFile.save();
                }
                break;
            }
        }
        int convertedCount = success.size();
        int failedCount = failed.size();
        ArrayList<String> files = new ArrayList<String>(failedCount + convertedCount);
        files.addAll(failed);
        files.addAll(success);
        this.sendMessage(files, convertedCount, failedCount);
        this.crazyManager.load(true);
    }

    private void processItems(@NotNull String name, @NotNull ConfigurationSection section) {
        String itemName = section.getString("name", name);
        List itemLore = section.getStringList("lore");
        section.set("lore", this.utils.convertLegacy(itemLore, true));
        String optionsMessage = section.getString("options.message", "");
        String optionsWorldMessage = section.getString("options.whitelist-worlds.message", "{prefix}You are not in any of the whitelisted worlds.");
        String optionsWhitelistMessage = section.getString("options.permission.whitelist-permission.message", "{prefix}You do not have the permission <red>{permission} <gray>to use this voucher.");
        String optionsBlacklistMessage = section.getString("options.permission.blacklist-permission.message", "{prefix}You already have the permission <red>{permission} <gray>so you can''t use this voucher.");
        section.set("name", (Object)this.utils.convertLegacy(itemName));
        section.set("options.message", (Object)this.utils.convertLegacy(optionsMessage));
        section.set("options.whitelist-worlds.message", (Object)this.utils.convertLegacy(optionsWorldMessage));
        section.set("options.permission.whitelist-permission.message", (Object)this.utils.convertLegacy(optionsWhitelistMessage));
        section.set("options.permission.blacklist-permission.message", (Object)this.utils.convertLegacy(optionsBlacklistMessage));
    }

    private void process(@NotNull ConfigurationSection section) {
        String optionsMessage = section.getString("options.message", "");
        String optionsWorldMessage = section.getString("options.whitelist-worlds.message", "{prefix}<red>You can not use that voucher here as you are not in a whitelisted world for this voucher.");
        String optionsWhitelistMessage = section.getString("options.permission.whitelist-permission.message", "{prefix}<red>You can not use that voucher here as you are not in a whitelisted world for this voucher.");
        String optionsBlacklistMessage = section.getString("options.permission.blacklist-permission.message", "{prefix}<red>You can not use that voucher here as you are not in a whitelisted world for this voucher.");
        section.set("options.message", (Object)this.utils.convertLegacy(optionsMessage));
        section.set("options.whitelist-worlds.message", (Object)this.utils.convertLegacy(optionsWorldMessage));
        section.set("options.permission.whitelist-permission.message", (Object)this.utils.convertLegacy(optionsWhitelistMessage));
        section.set("options.permission.blacklist-permission.message", (Object)this.utils.convertLegacy(optionsBlacklistMessage));
    }

    @Override
    public <T> void set(@NotNull ConfigurationSection section, @NotNull String path, @NotNull T value) {
        section.set(path, value);
    }

    @Override
    @NotNull
    public final Path getVouchersDirectory() {
        return this.dataPath.resolve("vouchers");
    }

    @Override
    @NotNull
    public final Path getCodesDirectory() {
        return this.dataPath.resolve("codes");
    }
}

