/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.commands.features.admin.migrate.types;

import com.badbones69.crazyvouchers.commands.features.admin.migrate.IVoucherMigrator;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.enums.MigrationType;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import libs.com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class VoucherSwitchMigrator
extends IVoucherMigrator {
    public VoucherSwitchMigrator(@NotNull CommandSender sender) {
        super(sender, MigrationType.VOUCHERS_SWITCH);
    }

    @Override
    public void run() {
        switch (this.config.getProperty(ConfigKeys.file_system)) {
            case SINGLE: {
                Path voucher_directory = this.getVouchersDirectory();
                Path code_directory = this.getCodesDirectory();
                Path voucher_file = this.dataPath.resolve("vouchers.yml");
                YamlConfiguration voucher_config = null;
                if (Files.exists(voucher_file, new LinkOption[0])) {
                    voucher_config = YamlConfiguration.loadConfiguration((File)voucher_file.toFile());
                }
                if (voucher_config != null) {
                    ConfigurationSection vouchers = voucher_config.getConfigurationSection("vouchers");
                    if (vouchers != null) {
                        for (String key : vouchers.getKeys(false)) {
                            ConfigurationSection entry = vouchers.getConfigurationSection(key);
                            Path path = voucher_directory.resolve(key);
                            if (!Files.exists(path, new LinkOption[0])) {
                                try {
                                    Files.createFile(path, new FileAttribute[0]);
                                }
                                catch (IOException exception) {
                                    exception.printStackTrace();
                                }
                            }
                            PaperCustomFile customFile = new PaperCustomFile(this.fileManager, path, consumer -> {});
                            customFile.load();
                            if (!customFile.isLoaded()) {
                                this.fusion.log("warn", "Failed to switch voucher {}, because section is null.", key);
                                continue;
                            }
                            if (entry == null) {
                                this.fusion.log("warn", "Failed to switch voucher {}, because configuration section is null.", key);
                                continue;
                            }
                            YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                            ConfigurationSection section = configuration.createSection("voucher");
                            this.processItems(entry, section);
                        }
                    } else {
                        this.fusion.log("warn", "Failed to move vouchers.yml into vouchers, because the section is null.", new Object[0]);
                    }
                } else {
                    this.fusion.log("warn", "Failed to move vouchers.yml into vouchers, because configuration is null.", new Object[0]);
                }
                Path code_file = this.dataPath.resolve("codes.yml");
                YamlConfiguration code_config = null;
                if (Files.exists(code_file, new LinkOption[0])) {
                    code_config = YamlConfiguration.loadConfiguration((File)code_file.toFile());
                }
                if (code_config != null) {
                    ConfigurationSection codes = code_config.getConfigurationSection("voucher-codes");
                    if (codes != null) {
                        for (String key : codes.getKeys(false)) {
                            ConfigurationSection entry = codes.getConfigurationSection(key);
                            Path path = code_directory.resolve(key);
                            if (!Files.exists(path, new LinkOption[0])) {
                                try {
                                    Files.createFile(path, new FileAttribute[0]);
                                }
                                catch (IOException exception) {
                                    exception.printStackTrace();
                                }
                            }
                            PaperCustomFile customFile = new PaperCustomFile(this.fileManager, path, consumer -> {});
                            customFile.load();
                            if (!customFile.isLoaded()) {
                                this.fusion.log("warn", "Failed to switch code {}, because section is null.", key);
                                continue;
                            }
                            if (entry == null) {
                                this.fusion.log("warn", "Failed to switch code {}, because configuration section is null.", key);
                                continue;
                            }
                            YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                            ConfigurationSection section = configuration.createSection("voucher-code");
                            this.process(entry, section);
                        }
                        break;
                    }
                    this.fusion.log("warn", "Failed to move codes.yml into vouchers, because the section is null.", new Object[0]);
                    break;
                }
                this.fusion.log("warn", "Failed to move codes.yml into vouchers, because configuration is null.", new Object[0]);
                break;
            }
            case MULTIPLE: {
                PaperCustomFile code_custom_file;
                PaperCustomFile voucher_custom_file;
                Path voucher_file = this.dataPath.resolve("vouchers.yml");
                if (Files.exists(voucher_file, new LinkOption[0])) {
                    try {
                        Files.createFile(voucher_file, new FileAttribute[0]);
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                }
                if ((voucher_custom_file = (PaperCustomFile)new PaperCustomFile(this.fileManager, voucher_file, consumer -> {}).load()).isLoaded()) {
                    ConfigurationSection new_section;
                    YamlConfiguration voucher_config = (YamlConfiguration)voucher_custom_file.getConfiguration();
                    ConfigurationSection configurationSection = new_section = voucher_config.contains("vouchers") ? voucher_config.getConfigurationSection("vouchers") : voucher_config.createSection("vouchers");
                    if (new_section != null) {
                        List<Path> vouchers = this.fusion.getFiles(this.dataPath.resolve("vouchers"), ".yml");
                        for (Path voucher : vouchers) {
                            String fileName = voucher.getFileName().toString();
                            PaperCustomFile customFile = new PaperCustomFile(this.fileManager, voucher, consumer -> {});
                            if (!customFile.isLoaded()) {
                                this.fusion.log("warn", "Failed to switch voucher {}, because configuration is null.", voucher);
                                continue;
                            }
                            YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                            ConfigurationSection entry = configuration.getConfigurationSection("voucher");
                            if (entry == null) {
                                this.fusion.log("warn", "Failed to switch voucher {}, because configuration section is null.", voucher);
                                continue;
                            }
                            ConfigurationSection section = new_section.createSection(fileName);
                            this.processItems(entry, section);
                            voucher_custom_file.save();
                            String path = section.getCurrentPath();
                            if (path == null) continue;
                            this.fusion.log("warn", "Successfully moved voucher {} to {} in vouchers.yml.", voucher, path);
                        }
                        this.fileManager.addPaperFile(voucher_custom_file);
                        this.fileManager.removeFile(voucher_file);
                        this.fusion.log("warn", "Added voucher {} to the cache, and removed the old voucher file named {}", voucher_custom_file.getPrettyName(), voucher_file);
                    } else {
                        this.fusion.log("warn", "Failed to move vouchers into vouchers.yml, because the section is null.", new Object[0]);
                    }
                } else {
                    this.fusion.log("warn", "Failed to move vouchers into vouchers.yml, because configuration is null.", new Object[0]);
                }
                Path code_file = this.dataPath.resolve("codes.yml");
                if (Files.exists(code_file, new LinkOption[0])) {
                    try {
                        Files.createFile(code_file, new FileAttribute[0]);
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                }
                if ((code_custom_file = (PaperCustomFile)new PaperCustomFile(this.fileManager, code_file, consumer -> {}).load()).isLoaded()) {
                    ConfigurationSection new_section;
                    YamlConfiguration code_config = (YamlConfiguration)code_custom_file.getConfiguration();
                    ConfigurationSection configurationSection = new_section = code_config.contains("voucher-codes") ? code_config.getConfigurationSection("voucher-codes") : code_config.createSection("voucher-codes");
                    if (new_section != null) {
                        List<Path> codes = this.fusion.getFiles(this.plugin.getDataPath().resolve("codes"), ".yml");
                        for (Path code : codes) {
                            String fileName = code.getFileName().toString();
                            PaperCustomFile customFile = new PaperCustomFile(this.fileManager, code, consumer -> {});
                            if (!customFile.isLoaded()) {
                                this.fusion.log("warn", "Failed to switch code {}, because configuration is null.", code);
                                continue;
                            }
                            YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                            ConfigurationSection entry = configuration.getConfigurationSection("voucher-code");
                            if (entry == null) {
                                this.fusion.log("warn", "Failed to switch code {}, because configuration section is null.", code);
                                continue;
                            }
                            ConfigurationSection section = new_section.createSection(fileName);
                            this.processItems(entry, section);
                            code_custom_file.save();
                            String path = section.getCurrentPath();
                            if (path == null) continue;
                            this.fusion.log("warn", "Successfully moved code {} to {} in codes.yml.", code, path);
                        }
                        this.fileManager.addPaperFile(code_custom_file);
                        this.fileManager.removeFile(code_file);
                        this.fusion.log("warn", "Added code {} to the cache, and removed the old code file named {}", code_custom_file.getPrettyName(), code_file);
                        break;
                    }
                    this.fusion.log("warn", "Failed to move codes into codes.yml, because the section is null.", new Object[0]);
                    break;
                }
                this.fusion.log("warn", "Failed to move codes into codes.yml, because configuration is null.", new Object[0]);
            }
        }
    }

    @Override
    public <T> void set(@NotNull ConfigurationSection section, @NotNull String path, @NotNull T value) {
        section.set(path, value);
    }

    @Override
    @NotNull
    public final Path getVouchersDirectory() {
        return this.dataPath.resolve("vouchers");
    }

    @Override
    @NotNull
    public final Path getCodesDirectory() {
        return this.dataPath.resolve("codes");
    }

    private void processItems(@NotNull ConfigurationSection entry, @NotNull ConfigurationSection section) {
        if (entry.contains("item")) {
            String item = entry.getString("item");
            section.set("item", (Object)item);
        }
        if (entry.contains("name")) {
            String name = entry.getString("name");
            section.set("name", (Object)name);
        }
        if (entry.contains("lore")) {
            List lore = entry.getStringList("lore");
            section.set("lore", (Object)lore);
        }
        if (entry.contains("player")) {
            String player = entry.getString("player");
            section.set("player", (Object)player);
        }
        if (entry.contains("glowing")) {
            boolean glowing = entry.getBoolean("glowing");
            section.set("glowing", (Object)glowing);
        }
        if (entry.contains("display-damage")) {
            int display_damage = entry.getInt("display-damage");
            section.set("display-damage", (Object)display_damage);
        }
        if (entry.contains("display-trim.material") && entry.contains("display-trim.pattern")) {
            String trim_material = entry.getString("display-trim.material");
            String trim_pattern = entry.getString("display-trim.pattern");
            section.set("display-trim.material", (Object)trim_material);
            section.set("display-trim.pattern", (Object)trim_pattern);
        }
        if (entry.contains("components.hide-tooltip")) {
            boolean hide_tooltip = entry.getBoolean("components.hide-tooltip");
            section.set("components.hide-tooltip", (Object)hide_tooltip);
        }
        if (entry.contains("options.is-edible")) {
            boolean edible = entry.getBoolean("options.is-edible");
            section.set("options.is-edible", (Object)edible);
        }
        this.process(entry, section);
    }

    private void process(@NotNull ConfigurationSection entry, @NotNull ConfigurationSection section) {
        if (entry.contains("commands")) {
            List commands = entry.getStringList("commands");
            section.set("commands", (Object)commands);
        }
        if (entry.contains("items")) {
            List items = entry.getStringList("items");
            section.set("items", (Object)items);
        }
        if (entry.contains("random-commands")) {
            List random_commands = entry.getStringList("random-commands");
            section.set("random-commands", (Object)random_commands);
        }
        if (entry.contains("chance-commands")) {
            List chance_commands = entry.getStringList("chance-commands");
            section.set("chance-commands", (Object)chance_commands);
        }
        if (entry.contains("options.message")) {
            String message = entry.getString("options.message");
            section.set("options.message", (Object)message);
        }
        if (entry.contains("options.whitelist-worlds.toggle")) {
            boolean toggle = entry.getBoolean("options.whitelist-worlds.toggle");
            section.set("options.whitelist-worlds.toggle", (Object)toggle);
        }
        if (entry.contains("options.whitelist-worlds.message")) {
            String message = entry.getString("options.whitelist-worlds.message");
            section.set("options.whitelist-worlds.message", (Object)message);
        }
        if (entry.contains("options.whitelist-worlds.worlds")) {
            List worlds = entry.getStringList("options.whitelist-worlds.worlds");
            section.set("options.whitelist-worlds.worlds", (Object)worlds);
        }
        if (entry.contains("options.permission.whitelist-permission.toggle")) {
            boolean toggle = entry.getBoolean("options.permission.whitelist-permission.toggle");
            section.set("options.permission.whitelist-permission.toggle", (Object)toggle);
        }
        if (entry.contains("options.permission.whitelist-permission.message")) {
            String message = entry.getString("options.permission.whitelist-permission.message");
            section.set("options.permission.whitelist-permission.message", (Object)message);
        }
        if (entry.contains("options.permission.whitelist-permission.permissions")) {
            List permissions = entry.getStringList("options.permission.whitelist-permission.permissions");
            section.set("options.permission.whitelist-permission.permissions", (Object)permissions);
        }
        if (entry.contains("options.permission.blacklist-permission.toggle")) {
            boolean toggle = entry.getBoolean("options.permission.blacklist-permission.toggle");
            section.set("options.permission.blacklist-permission.toggle", (Object)toggle);
        }
        if (entry.contains("options.permission.blacklist-permission.message")) {
            String message = entry.getString("options.permission.blacklist-permission.message");
            section.set("options.permission.blacklist-permission.message", (Object)message);
        }
        if (entry.contains("options.permission.blacklist-permission.permissions")) {
            List permissions = entry.getStringList("options.permission.blacklist-permission.permissions");
            section.set("options.permission.blacklist-permission.permissions", (Object)permissions);
        }
        if (entry.contains("options.limiter.toggle")) {
            boolean toggle = entry.getBoolean("options.limiter.toggle");
            section.set("options.limiter.toggle", (Object)toggle);
        }
        if (entry.contains("options.limiter.amount")) {
            int amount = entry.getInt("options.limiter.amount");
            section.set("options.limiter.amount", (Object)amount);
        }
        if (entry.contains("options.two-step-authentication")) {
            boolean two_step_authentication = entry.getBoolean("options.two-step-authentication");
            section.set("options.two-step-authentication", (Object)two_step_authentication);
        }
        if (entry.contains("options.sound.toggle")) {
            boolean toggle = entry.getBoolean("options.sound.toggle");
            section.set("options.sound.toggle", (Object)toggle);
        }
        if (entry.contains("options.sound.volume")) {
            double volume = entry.getDouble("options.sound.volume");
            section.set("options.sound.volume", (Object)volume);
        }
        if (entry.contains("options.sound.pitch")) {
            double pitch = entry.getDouble("options.sound.pitch");
            section.set("options.sound.pitch", (Object)pitch);
        }
        if (entry.contains("options.sound.sounds")) {
            List sounds = entry.getStringList("options.sound.sounds");
            section.set("options.sound.sounds", (Object)sounds);
        }
        if (entry.contains("options.firework.toggle")) {
            boolean toggle = entry.getBoolean("options.firework.toggle");
            section.set("options.firework.toggle", (Object)toggle);
        }
        if (entry.contains("options.fireworks.colors")) {
            String colors = entry.getString("options.fireworks.colors");
            section.set("options.fireworks.colors", (Object)colors);
        }
    }
}

