/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.commands.features.admin.migrate.types;

import com.badbones69.crazyvouchers.api.enums.config.Messages;
import com.badbones69.crazyvouchers.api.enums.misc.PersistentKeys;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.IVoucherMigrator;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.enums.MigrationType;
import com.badbones69.crazyvouchers.config.ConfigManager;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import de.tr7zw.changeme.nbtapi.NBT;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class VoucherNbtMigrator
extends IVoucherMigrator {
    public VoucherNbtMigrator(@NotNull CommandSender sender) {
        super(sender, MigrationType.VOUCHERS_NBT_API);
    }

    @Override
    public void run() {
        Player player = (Player)this.sender;
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();
        AtomicInteger count = new AtomicInteger();
        for (ItemStack item : contents) {
            if (item == null || item.getType() == Material.AIR) continue;
            NBT.get(item, nbt -> {
                boolean hasVoucherTag = nbt.hasTag("voucher");
                boolean hasVoucherArg = nbt.hasTag("argument");
                if (hasVoucherTag || hasVoucherArg) {
                    count.getAndIncrement();
                }
                if (hasVoucherTag) {
                    item.editPersistentDataContainer(container -> {
                        if (ConfigManager.getConfig().getProperty(ConfigKeys.dupe_protection).booleanValue()) {
                            container.set(PersistentKeys.dupe_protection.getNamespacedKey(), PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
                        }
                        container.set(PersistentKeys.voucher_item.getNamespacedKey(), PersistentDataType.STRING, (Object)nbt.getString("voucher"));
                    });
                }
                if (hasVoucherArg) {
                    item.editPersistentDataContainer(container -> container.set(PersistentKeys.voucher_arg.getNamespacedKey(), PersistentDataType.STRING, (Object)nbt.getString("argument")));
                }
            });
        }
        this.fusion.log("warn", "Successfully migrated <green>{}</green> items that were using legacy api!", count);
        Messages.migrated_old_vouchers.sendMessage((Audience)player);
    }
}

