/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.commands.features.admin.migrate.types;

import com.badbones69.crazyvouchers.api.enums.FileSystem;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.IVoucherMigrator;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.enums.MigrationType;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class VoucherFileMigrator
extends IVoucherMigrator {
    public VoucherFileMigrator(@NotNull CommandSender sender, @NotNull MigrationType type) {
        super(sender, type);
    }

    @Override
    public void run() {
        switch (this.type) {
            case VOUCHERS_RENAME: {
                Path oldPath = this.dataPath.resolve("voucher-codes.yml");
                if (!Files.exists(oldPath, new LinkOption[0])) {
                    this.fusion.log("warn", "The file {} does not exist at the path.", oldPath);
                    return;
                }
                Path newPath = this.dataPath.resolve("codes.yml");
                if (Files.exists(newPath, new LinkOption[0])) {
                    Path backup = this.dataPath.resolve("backups");
                    if (!Files.exists(backup, new LinkOption[0])) {
                        try {
                            Files.createDirectory(backup, new FileAttribute[0]);
                            this.fusion.log("warn", "Successfully created the backup {}", backup);
                        }
                        catch (IOException exception) {
                            exception.printStackTrace();
                        }
                    }
                    try {
                        Files.move(backup, newPath, StandardCopyOption.REPLACE_EXISTING);
                        this.fusion.log("warn", "Successfully moved {} to {}.", backup, newPath);
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    Files.move(oldPath, newPath, StandardCopyOption.REPLACE_EXISTING);
                    this.fusion.log("warn", "Successfully moved {} to {}.", oldPath, newPath);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (this.config.getProperty(ConfigKeys.file_system) != FileSystem.SINGLE) break;
                this.fileManager.removeFile(oldPath);
                this.fileManager.addPaperFile(newPath);
                this.crazyManager.loadCodes();
            }
        }
    }
}

