/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.commands.features.admin.migrate.types;

import com.badbones69.crazyvouchers.api.enums.FileKeys;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.IVoucherMigrator;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.enums.MigrationType;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class VoucherDeprecated
extends IVoucherMigrator {
    public VoucherDeprecated(@NotNull CommandSender sender) {
        super(sender, MigrationType.VOUCHERS_DEPRECATED);
    }

    @Override
    public void run() {
        ArrayList<Object> failed = new ArrayList<Object>();
        ArrayList<Object> success = new ArrayList<Object>();
        switch (this.config.getProperty(ConfigKeys.file_system)) {
            case SINGLE: {
                YamlConfiguration vouchers = FileKeys.vouchers.getConfiguration();
                try {
                    ConfigurationSection section = vouchers.getConfigurationSection("vouchers");
                    if (section != null) {
                        for (Object key : section.getKeys(false)) {
                            List commands;
                            ConfigurationSection voucher = section.getConfigurationSection((String)key);
                            if (voucher == null) {
                                this.fusion.log("warn", "<red>{}</red> is not a valid configuration section.", key);
                                continue;
                            }
                            if (voucher.contains("item")) {
                                String displayItem = voucher.getString("item", "");
                                if (displayItem.contains("#")) {
                                    String[] split = displayItem.split("#");
                                    String material = split[0];
                                    String model_data = split[1];
                                    section.set("item", (Object)material);
                                    section.set("custom-model-data", (Object)model_data);
                                } else {
                                    this.fusion.log("warn", "<red>vouchers.{}.item</red> does not contain <red>custom model data</red>, We cannot migrate.", key);
                                }
                            } else {
                                this.fusion.log("warn", "<red>vouchers.{}.item</red> does not exist.", key);
                            }
                            if (voucher.contains("random-commands") && voucher.isList("random-commands")) {
                                commands = voucher.getStringList("random-commands");
                                voucher.set("random-commands", null);
                                ConfigurationSection newSection = voucher.createSection("random-commands");
                                newSection.set("%s.commands".formatted(UUID.randomUUID()), (Object)commands);
                            }
                            if (!voucher.contains("chance-commands")) continue;
                            commands = voucher.getStringList("chance-commands");
                            this.convertCommands(voucher, commands);
                        }
                        FileKeys.vouchers.save();
                    }
                    success.add("<green>\u2937 vouchers.yml");
                }
                catch (Exception exception) {
                    failed.add("<red>\u2937 vouchers.yml");
                }
                YamlConfiguration codes = FileKeys.codes.getConfiguration();
                try {
                    ConfigurationSection section = codes.getConfigurationSection("voucher-codes");
                    if (section != null) {
                        for (String key : section.getKeys(false)) {
                            List commands;
                            ConfigurationSection voucher = section.getConfigurationSection(key);
                            if (voucher == null) {
                                this.fusion.log("warn", "<red>{}</red> is not a valid configuration section.", key);
                                continue;
                            }
                            if (voucher.contains("random-commands") && voucher.isList("random-commands")) {
                                commands = voucher.getStringList("random-commands");
                                voucher.set("random-commands", null);
                                ConfigurationSection newSection = voucher.createSection("random-commands");
                                newSection.set("%s.commands".formatted(UUID.randomUUID()), (Object)commands);
                            }
                            if (!voucher.contains("chance-commands")) continue;
                            commands = voucher.getStringList("chance-commands");
                            this.convertCommands(voucher, commands);
                        }
                        FileKeys.codes.save();
                    }
                    success.add("<green>\u2937 codes.yml");
                }
                catch (Exception exception) {
                    failed.add("<red>\u2937 codes.yml");
                }
                break;
            }
            case MULTIPLE: {
                Path voucher_dir = this.dataPath.resolve("vouchers");
                List<Path> voucher_files = this.fusion.getFiles(voucher_dir, ".yml");
                for (Path path : voucher_files) {
                    List commands;
                    Optional<PaperCustomFile> optional = this.fileManager.getPaperFile(path);
                    String fileName = path.getFileName().toString();
                    if (optional.isEmpty()) {
                        this.fusion.log("warn", "<red>{}</red> does not exist in the file cache", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    PaperCustomFile customFile = optional.get();
                    if (!customFile.isLoaded()) {
                        this.fusion.log("warn", "<red>{}</red> configuration is invalid, likely not loaded properly. Please check console :)", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                    ConfigurationSection section = configuration.getConfigurationSection("voucher");
                    if (section == null) {
                        this.fusion.log("warn", "Configuration section for <red>{}</red> was not found.", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    if (section.contains("item")) {
                        String displayItem = section.getString("item", "");
                        if (displayItem.contains("#")) {
                            String[] split = displayItem.split("#");
                            String material = split[0];
                            String model_data = split[1];
                            section.set("item", (Object)material);
                            section.set("custom-model-data", (Object)model_data);
                        } else {
                            this.fusion.log("warn", "<red>{}</red> does not contain <red>voucher.item</red> path in the configuration section.", fileName);
                        }
                    } else {
                        this.fusion.log("warn", "<red>vouchers.{}.item</red> does not exist.", fileName);
                    }
                    if (section.contains("random-commands") && section.isList("random-commands")) {
                        commands = section.getStringList("random-commands");
                        section.set("random-commands", null);
                        ConfigurationSection newSection = section.createSection("random-commands");
                        commands.forEach(command -> newSection.set("%s.commands".formatted(UUID.randomUUID()), List.of(command)));
                    }
                    if (section.contains("chance-commands")) {
                        commands = section.getStringList("chance-commands");
                        this.convertCommands(section, commands);
                    }
                    success.add("<green>\u2937 " + fileName);
                    customFile.save();
                }
                Path code_dir = this.dataPath.resolve("codes");
                List<Path> code_files = this.fusion.getFiles(code_dir, ".yml");
                for (Path path : code_files) {
                    List commands;
                    Optional<PaperCustomFile> optional = this.fileManager.getPaperFile(path);
                    String fileName = path.getFileName().toString();
                    if (optional.isEmpty()) {
                        this.fusion.log("warn", "<red>{}</red> does not exist in the file cache", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    PaperCustomFile customFile = optional.get();
                    if (!customFile.isLoaded()) {
                        this.fusion.log("warn", "<red>{}</red> configuration is invalid, likely not loaded properly. Please check console :)", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                    ConfigurationSection section = configuration.getConfigurationSection("voucher-code");
                    if (section == null) {
                        this.fusion.log("warn", "Configuration section for <red>{}</red> was not found.", fileName);
                        failed.add("<red>\u2937 " + fileName);
                        continue;
                    }
                    if (section.contains("random-commands") && section.isList("random-commands")) {
                        commands = section.getStringList("random-commands");
                        section.set("random-commands", null);
                        ConfigurationSection newSection = section.createSection("random-commands");
                        commands.forEach(command -> newSection.set("%s.commands".formatted(UUID.randomUUID()), List.of(command)));
                    }
                    if (section.contains("chance-commands")) {
                        commands = section.getStringList("chance-commands");
                        this.convertCommands(section, commands);
                    }
                    success.add("<green>\u2937 " + fileName);
                    customFile.save();
                }
                break;
            }
        }
        int convertedCount = success.size();
        int failedCount = failed.size();
        ArrayList<String> files = new ArrayList<String>(failedCount + convertedCount);
        files.addAll(failed);
        files.addAll(success);
        this.sendMessage(files, convertedCount, failedCount);
        this.crazyManager.load(true);
    }

    private void convertCommands(@NotNull ConfigurationSection section, @NotNull List<String> commands) {
        for (String command : commands) {
            ConfigurationSection existingSection = section.getConfigurationSection("random-commands");
            if (existingSection == null) {
                existingSection = section.createSection("random-commands");
            }
            ConfigurationSection commandSection = existingSection.createSection(UUID.randomUUID().toString());
            String[] chance = command.split(" ");
            commandSection.set("weight", (Object)Double.parseDouble(chance[0]));
            if (commandSection.contains("commands")) {
                List values = commandSection.getStringList("commands");
                values.add(command.replaceFirst(chance[0], "").replaceFirst(" ", ""));
                commandSection.set("commands", (Object)values);
                continue;
            }
            commandSection.set("commands", List.of(command.replaceFirst(chance[0], "").replaceFirst(" ", "")));
        }
        section.set("chance-commands", null);
    }
}

