/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.commands.features.admin.migrate;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazyvouchers.CrazyVouchers;
import com.badbones69.crazyvouchers.api.CrazyManager;
import com.badbones69.crazyvouchers.api.enums.config.Messages;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.enums.MigrationType;
import com.badbones69.crazyvouchers.config.ConfigManager;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import libs.com.ryderbelserion.fusion.core.utils.StringUtils;
import libs.com.ryderbelserion.fusion.paper.FusionPaper;
import libs.com.ryderbelserion.fusion.paper.files.PaperFileManager;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public abstract class IVoucherMigrator {
    @NotNull
    protected final CrazyVouchers plugin = CrazyVouchers.get();
    @NotNull
    protected final FusionPaper fusion = this.plugin.getFusion();
    @NotNull
    protected final StringUtils utils = this.fusion.getStringUtils();
    @NotNull
    protected final CrazyManager crazyManager = this.plugin.getCrazyManager();
    @NotNull
    protected final SettingsManager config = ConfigManager.getConfig();
    @NotNull
    protected final SettingsManager messages = ConfigManager.getMessages();
    @NotNull
    protected final PaperFileManager fileManager = this.plugin.getFileManager();
    @NotNull
    protected final Path dataPath = this.plugin.getDataPath();
    protected final CommandSender sender;
    protected final MigrationType type;
    protected final long startTime = System.nanoTime();

    public IVoucherMigrator(@NotNull CommandSender sender, @NotNull MigrationType type) {
        this.sender = sender;
        this.type = type;
    }

    public <T> void set(@NotNull ConfigurationSection section, @NotNull String path, @NotNull T value) {
    }

    public abstract void run();

    @NotNull
    public Path getVouchersDirectory() {
        return this.dataPath;
    }

    @NotNull
    public Path getCodesDirectory() {
        return this.dataPath;
    }

    public void sendMessage(@NotNull List<String> files, int success, int failed) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (files.size() > 1) {
            placeholders.put("{files}", this.utils.toString(files));
        } else {
            placeholders.put("{files}", files.getFirst());
        }
        placeholders.put("{succeeded_amount}", String.valueOf(success));
        placeholders.put("{failed_amount}", String.valueOf(failed));
        placeholders.put("{type}", this.type.getName());
        placeholders.put("{time}", this.time());
        Messages.successfully_migrated.sendMessage((Audience)this.sender, placeholders);
    }

    @NotNull
    public final String time() {
        double time = (double)(System.nanoTime() - this.startTime) / 1.0E9;
        return String.format(Locale.ROOT, "%.3fs", time);
    }
}

