/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.api.enums.config;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.PropertyInitializer;
import ch.jalu.configme.resource.PropertyReader;
import com.badbones69.crazyvouchers.api.enums.FileSystem;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import com.badbones69.crazyvouchers.config.types.locale.MessageKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public enum Properties {
    command_prefix(ConfigKeys.command_prefix, PropertyInitializer.newProperty("Settings.Prefix", ConfigKeys.command_prefix.getDefaultValue())),
    must_be_in_survival(ConfigKeys.must_be_in_survival, PropertyInitializer.newProperty("Settings.Must-Be-In-Survival", ConfigKeys.must_be_in_survival.getDefaultValue()), false),
    prevent_using_vouchers_in_recipes_toggle(ConfigKeys.prevent_using_vouchers_in_recipes_toggle, PropertyInitializer.newProperty("Settings.Prevent-Using-Vouchers-In-Recipes.Toggle", ConfigKeys.prevent_using_vouchers_in_recipes_toggle.getDefaultValue()), false),
    prevent_using_vouchers_in_recipes_alert(ConfigKeys.prevent_using_vouchers_in_recipes_alert, PropertyInitializer.newProperty("Settings.Prevent-Using-Vouchers-In-Recipes.Alert", ConfigKeys.prevent_using_vouchers_in_recipes_alert.getDefaultValue()), false),
    file_system(ConfigKeys.file_system, PropertyInitializer.newProperty("settings.use-old-file-system", "MULTIPLE"), ""),
    survival_mode(MessageKeys.survival_mode, PropertyInitializer.newProperty("Messages.Survival-Mode", MessageKeys.survival_mode.getDefaultValue())),
    no_permission(MessageKeys.no_permission, PropertyInitializer.newProperty("Messages.No-Permission", MessageKeys.no_permission.getDefaultValue())),
    no_permission_to_use_voucher(MessageKeys.no_permission_to_use_voucher, PropertyInitializer.newProperty("Messages.No-Permission-To-Voucher", MessageKeys.no_permission_to_use_voucher.getDefaultValue())),
    no_permission_to_use_voucher_in_offhand(MessageKeys.no_permission_to_use_voucher_in_offhand, PropertyInitializer.newProperty("Messages.No-Permission-To-Use-Voucher-In-OffHand", MessageKeys.no_permission_to_use_voucher_in_offhand.getDefaultValue())),
    cannot_put_items_in_crafting_table(MessageKeys.cannot_put_items_in_crafting_table, PropertyInitializer.newProperty("Messages.Cannot-Put-Items-In-Crafting-Table", MessageKeys.cannot_put_items_in_crafting_table.getDefaultValue())),
    not_online(MessageKeys.not_online, PropertyInitializer.newProperty("Messages.Not-Online", MessageKeys.not_online.getDefaultValue())),
    two_step_authentication(MessageKeys.two_step_authentication, PropertyInitializer.newProperty("Messages.Two-Step-Authentication", MessageKeys.two_step_authentication.getDefaultValue())),
    hit_voucher_limit(MessageKeys.hit_voucher_limit, PropertyInitializer.newProperty("Messages.Hit-Limit", MessageKeys.hit_voucher_limit.getDefaultValue())),
    not_a_number(MessageKeys.not_a_number, PropertyInitializer.newProperty("Messages.Not-A-Number", MessageKeys.not_a_number.getDefaultValue())),
    not_a_voucher(MessageKeys.not_a_voucher, PropertyInitializer.newProperty("Messages.Not-A-Voucher", MessageKeys.not_a_voucher.getDefaultValue())),
    not_in_whitelist_world(MessageKeys.not_in_whitelist_world, PropertyInitializer.newProperty("Messages.Not-In-Whitelisted-World", MessageKeys.not_in_whitelist_world.getDefaultValue())),
    unstack_item(MessageKeys.unstack_item, PropertyInitializer.newProperty("Messages.Unstack-Item", MessageKeys.unstack_item.getDefaultValue())),
    has_blacklist_permission(MessageKeys.has_blacklist_permission, PropertyInitializer.newProperty("Messages.Has-Blacklist-Permission", MessageKeys.has_blacklist_permission.getDefaultValue())),
    code_used(MessageKeys.code_used, PropertyInitializer.newProperty("Messages.Code-Used", MessageKeys.code_used.getDefaultValue())),
    code_unavailable(MessageKeys.code_unavailable, PropertyInitializer.newProperty("Messages.Code-UnAvailable", MessageKeys.code_unavailable.getDefaultValue())),
    sent_voucher(MessageKeys.sent_voucher, PropertyInitializer.newProperty("Messages.Given-A-Voucher", MessageKeys.sent_voucher.getDefaultValue())),
    sent_everyone_voucher(MessageKeys.sent_everyone_voucher, PropertyInitializer.newProperty("Messages.Given-All-Players-Voucher", MessageKeys.sent_everyone_voucher.getDefaultValue())),
    player_only(MessageKeys.player_only, PropertyInitializer.newProperty("Messages.Players-Only", MessageKeys.player_only.getDefaultValue())),
    config_reload(MessageKeys.config_reload, PropertyInitializer.newProperty("Messages.Config-Reload", MessageKeys.config_reload.getDefaultValue())),
    help(MessageKeys.help, PropertyInitializer.newListProperty("Messages.Help", MessageKeys.help.getDefaultValue()), Collections.emptyList());

    private Property<String> newString;
    private Property<String> oldString;
    private Property<FileSystem> newValue;
    private Property<Boolean> newBoolean;
    private Property<Boolean> oldBoolean;
    private Property<Integer> newInteger;
    private Property<Integer> oldInteger;
    private Property<List<String>> newList;
    private Property<List<String>> oldList;

    private Properties(Property<String> newString, Property<String> oldString) {
        this.newString = newString;
        this.oldString = oldString;
    }

    public boolean moveString(@NotNull PropertyReader reader, @NotNull ConfigurationData configuration) {
        String key = reader.getString(this.oldString.getPath());
        if (key == null) {
            return false;
        }
        configuration.setValue(this.newString, this.replace(this.oldString.determineValue(reader).getValue()));
        return true;
    }

    private Properties(@NotNull Property<FileSystem> newValue, Property<String> oldString, String dummy) {
        this.newValue = newValue;
        this.oldString = oldString;
    }

    public boolean moveBooleanToString(@NotNull PropertyReader reader, @NotNull ConfigurationData configuration) {
        String key = reader.getString(this.oldString.getPath());
        if (key == null) {
            return false;
        }
        boolean value = Boolean.parseBoolean(this.oldString.determineValue(reader).getValue());
        FileSystem toggle = value ? FileSystem.SINGLE : FileSystem.MULTIPLE;
        configuration.setValue(this.newValue, toggle);
        return true;
    }

    private Properties(Property<Boolean> newBoolean, Property<Boolean> oldBoolean, boolean dummy) {
        this.newBoolean = newBoolean;
        this.oldBoolean = oldBoolean;
    }

    public boolean moveBoolean(@NotNull PropertyReader reader, @NotNull ConfigurationData configuration) {
        Boolean key = reader.getBoolean(this.oldBoolean.getPath());
        if (key == null) {
            return false;
        }
        configuration.setValue(this.newBoolean, this.oldBoolean.determineValue(reader).getValue());
        return true;
    }

    private Properties(Property<Integer> newInteger, Property<Integer> oldInteger, int dummy) {
        this.newInteger = newInteger;
        this.oldInteger = oldInteger;
    }

    public boolean moveInteger(@NotNull PropertyReader reader, @NotNull ConfigurationData configuration) {
        Integer key = reader.getInt(this.oldInteger.getPath());
        if (key == null) {
            return false;
        }
        configuration.setValue(this.newInteger, this.oldInteger.determineValue(reader).getValue());
        return true;
    }

    private Properties(@NotNull Property<List<String>> newList, Property<List<String>> oldList, List<String> dummy) {
        this.newList = newList;
        this.oldList = oldList;
    }

    public boolean moveList(@NotNull PropertyReader reader, @NotNull ConfigurationData configuration) {
        List<?> key = reader.getList(this.oldList.getPath());
        if (key == null) {
            return false;
        }
        ArrayList list = new ArrayList();
        this.oldList.determineValue(reader).getValue().forEach(line -> list.add(this.replace((String)line)));
        configuration.setValue(this.newList, list);
        return true;
    }

    @NotNull
    private String replace(@NotNull String message) {
        return message.replaceAll("%Arg%", "{arg}").replaceAll("%arg%", "{arg}").replaceAll("%Player%", "{player}").replaceAll("%player%", "{player}").replaceAll("%Prefix%", "").replaceAll("%prefix%", "").replaceAll("%Random%", "{random}").replaceAll("%random%", "{random}").replaceAll("%World%", "{world}").replaceAll("%world%", "{world}").replaceAll("%voucher%", "{voucher}").replaceAll("%Voucher%", "{voucher}").replaceAll("%X%", "{x}").replaceAll("%x%", "{x}").replaceAll("%Y%", "{y}").replaceAll("%y%", "{y}").replaceAll("%Z%", "{z}").replaceAll("%z%", "{z}").replaceAll("%Permission%", "{permission}").replaceAll("%permission%", "{permission}");
    }
}

