/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.api.builders;

import com.badbones69.crazyvouchers.CrazyVouchers;
import libs.com.ryderbelserion.fusion.paper.FusionPaper;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public abstract class InventoryBuilder
implements InventoryHolder,
Listener {
    @NotNull
    protected final CrazyVouchers plugin = CrazyVouchers.get();
    @NotNull
    protected final Server server = this.plugin.getServer();
    @NotNull
    protected final FusionPaper fusion = this.plugin.getFusion();
    private Inventory inventory;
    private Player player;
    private String title;
    private int size;
    private int page;

    public InventoryBuilder(@NotNull Player player, int size, @NotNull String title) {
        this.title = title;
        this.player = player;
        this.size = size;
        this.inventory = this.server.createInventory((InventoryHolder)this, this.size, this.fusion.parse(this.title));
    }

    public InventoryBuilder(@NotNull Player player, int size, int page, @NotNull String title) {
        this.title = title;
        this.player = player;
        this.size = size;
        this.page = page;
        this.inventory = this.server.createInventory((InventoryHolder)this, this.size, this.fusion.parse(this.title));
    }

    public InventoryBuilder() {
    }

    public abstract InventoryBuilder build();

    public abstract void run(InventoryClickEvent var1);

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        this.run(event);
    }

    public void size(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPage() {
        return this.page;
    }

    public void title(@NotNull String title) {
        this.title = title;
    }

    public boolean contains(@NotNull String message) {
        return this.title.contains(message);
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

