/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.numbers;

import ch.jalu.typeresolver.numbers.ValueRange;
import ch.jalu.typeresolver.numbers.ValueRangeComparison;
import java.util.Optional;

public interface NumberType<N> {
    public Class<N> getType();

    public N convertToBounds(Number var1);

    default public Optional<N> convertIfNoLossOfMagnitude(Number number) {
        if (this.compareToValueRange(number) == ValueRangeComparison.WITHIN_RANGE) {
            return Optional.of(this.convertUnsafe(number));
        }
        return Optional.empty();
    }

    public N convertUnsafe(Number var1);

    public ValueRange<N> getValueRange();

    public ValueRangeComparison compareToValueRange(Number var1);

    default public boolean supportsAllValuesOf(NumberType<?> other) {
        if (other == this) {
            return true;
        }
        return this.getValueRange().supportsAllValuesOf(other.getValueRange());
    }
}

