/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.array;

import ch.jalu.typeresolver.array.ArrayTypeProperties;
import java.util.Objects;

public class ArrayClassProperties
implements ArrayTypeProperties {
    private final Class<?> componentType;
    private final int dimension;

    public ArrayClassProperties(Class<?> clazz) {
        Class<?> component = clazz;
        int dimension = 0;
        while (component.isArray()) {
            component = component.getComponentType();
            ++dimension;
        }
        this.componentType = component;
        this.dimension = dimension;
    }

    public ArrayClassProperties(Class<?> componentType, int dimension) {
        this.componentType = componentType;
        this.dimension = dimension;
    }

    @Override
    public Class<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayClassProperties) {
            ArrayClassProperties that = (ArrayClassProperties)obj;
            return this.dimension == that.dimension && Objects.equals(this.componentType, that.componentType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.componentType);
    }

    public String toString() {
        return "ArrayClassProperties[componentType='" + this.componentType + "', dimension=" + this.dimension + "]";
    }
}

