/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver;

import ch.jalu.typeresolver.CommonTypeUtils;
import ch.jalu.typeresolver.TypeVariableResolver;
import ch.jalu.typeresolver.array.ArrayTypeProperties;
import ch.jalu.typeresolver.array.ArrayTypeUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

final class TypeVisitor {
    private TypeVisitor() {
    }

    static Set<Type> gatherAllTypes(Type type) {
        return TypeVisitor.gatherAllTypes(type, new TypeVariableResolver(type));
    }

    static Set<Type> gatherAllTypes(Type type, TypeVariableResolver resolver) {
        return TypeVisitor.gatherAllTypes(type, resolver, new HashSet(), Function.identity());
    }

    static <E, C extends Collection<? super E>> C gatherAllTypes(Type type, TypeVariableResolver resolver, C collection, Function<Type, E> typeToElementFn) {
        if (CommonTypeUtils.getDefinitiveClass(type) != null) {
            Consumer<Type> typeConsumer = aType -> {
                Object typeAsElement = typeToElementFn.apply(resolver.resolve((Type)aType));
                collection.add(typeAsElement);
            };
            TypeVisitor.visitClassesRecursively(type, typeConsumer);
        }
        return collection;
    }

    static void visitAllTypes(Type type, TypeVariableResolver resolver, Consumer<Type> typeConsumer) {
        if (CommonTypeUtils.getDefinitiveClass(type) != null) {
            TypeVisitor.visitClassesRecursively(type, aType -> typeConsumer.accept(resolver.resolve((Type)aType)));
        }
    }

    private static void visitClassesRecursively(@Nullable Type type, Consumer<Type> typeConsumer) {
        if (type == null) {
            return;
        }
        Class<?> typeAsClass = CommonTypeUtils.getDefinitiveClass(type);
        if (!typeAsClass.isArray()) {
            typeConsumer.accept(type);
            TypeVisitor.visitClassesRecursively(typeAsClass.getGenericSuperclass(), typeConsumer);
            for (Type genericInterface : typeAsClass.getGenericInterfaces()) {
                TypeVisitor.visitClassesRecursively(genericInterface, typeConsumer);
            }
        } else {
            ArrayTypeProperties arrayProperties = ArrayTypeUtils.getArrayProperty(type);
            List<Type> componentTypeList = TypeVisitor.gatherAllTypesOfComponent(arrayProperties);
            for (Type component : componentTypeList) {
                Type arrayType = ArrayTypeUtils.createArrayType(component, arrayProperties.getDimension());
                typeConsumer.accept(arrayType);
            }
            List<Type> arrayClassParents = Arrays.asList(Serializable.class, Cloneable.class, Object.class);
            for (int dimension = arrayProperties.getDimension() - 1; dimension >= 0; --dimension) {
                for (Type arrayClassParent : arrayClassParents) {
                    Type arrayType = ArrayTypeUtils.createArrayType(arrayClassParent, dimension);
                    typeConsumer.accept(arrayType);
                }
            }
        }
    }

    private static List<Type> gatherAllTypesOfComponent(ArrayTypeProperties arrayProperties) {
        TypeVariableResolver componentResolver = new TypeVariableResolver(arrayProperties.getComponentType());
        ArrayList<Type> typesOfComponent = new ArrayList<Type>();
        TypeVisitor.visitAllTypes(arrayProperties.getComponentType(), componentResolver, typesOfComponent::add);
        if (!CommonTypeUtils.getDefinitiveClass(arrayProperties.getComponentType()).isPrimitive() && !typesOfComponent.contains(Object.class)) {
            typesOfComponent.add((Type)((Object)Object.class));
        }
        return typesOfComponent;
    }
}

