/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver;

import java.util.EnumSet;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class EnumUtils {
    private EnumUtils() {
    }

    public static <T> Optional<T> tryValueOf(@Nullable Class<T> clazz, @Nullable String name) {
        if (clazz == null || !clazz.isEnum() || name == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Enum.valueOf(clazz, name));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    public static <T> Optional<T> tryValueOfCaseInsensitive(@Nullable Class<T> clazz, @Nullable String name) {
        if (clazz == null || !clazz.isEnum() || name == null) {
            return Optional.empty();
        }
        for (T enumConstant : clazz.getEnumConstants()) {
            if (!name.equalsIgnoreCase(((Enum)enumConstant).name())) continue;
            return Optional.of(enumConstant);
        }
        return Optional.empty();
    }

    public static Optional<Class<? extends Enum<?>>> asEnumClassIfPossible(@Nullable Class<?> clazz) {
        if (clazz != null && clazz.isEnum()) {
            return Optional.of(clazz);
        }
        return Optional.empty();
    }

    public static boolean isEnumOrEnumEntryType(@Nullable Class<?> clazz) {
        return EnumUtils.getAssociatedEnumType(clazz).isPresent();
    }

    public static Optional<Class<? extends Enum<?>>> getAssociatedEnumType(@Nullable Class<?> clazz) {
        if (clazz == null || !Enum.class.isAssignableFrom(clazz)) {
            return Optional.empty();
        }
        Class<?> enumClass = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
        return Optional.of(enumClass);
    }

    public static <E extends Enum<E>> Collector<E, ?, EnumSet<E>> toEnumSet(Class<E> enumType) {
        return Collectors.toCollection(() -> EnumSet.noneOf(enumType));
    }
}

