/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.types;

import ch.jalu.configme.internal.ConversionUtils;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.BooleanType;
import ch.jalu.configme.properties.types.NumberType;
import ch.jalu.configme.properties.types.PropertyType;
import ch.jalu.configme.properties.types.StringType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineArrayPropertyType<T>
implements PropertyType<T[]> {
    public static final InlineArrayPropertyType<Boolean> BOOLEAN = new InlineArrayPropertyType<Boolean>(BooleanType.BOOLEAN, ",", true, Boolean[]::new);
    public static final InlineArrayPropertyType<Byte> BYTE = new InlineArrayPropertyType<Byte>(NumberType.BYTE, ",", true, Byte[]::new);
    public static final InlineArrayPropertyType<Short> SHORT = new InlineArrayPropertyType<Short>(NumberType.SHORT, ",", true, Short[]::new);
    public static final InlineArrayPropertyType<Integer> INTEGER = new InlineArrayPropertyType<Integer>(NumberType.INTEGER, ",", true, Integer[]::new);
    public static final InlineArrayPropertyType<Long> LONG = new InlineArrayPropertyType<Long>(NumberType.LONG, ",", true, Long[]::new);
    public static final InlineArrayPropertyType<Float> FLOAT = new InlineArrayPropertyType<Float>(NumberType.FLOAT, ",", true, Float[]::new);
    public static final InlineArrayPropertyType<Double> DOUBLE = new InlineArrayPropertyType<Double>(NumberType.DOUBLE, ",", true, Double[]::new);
    public static final InlineArrayPropertyType<String> STRING = new InlineArrayPropertyType<String>(StringType.STRING, "\n", false, String[]::new);
    public static final InlineArrayPropertyType<BigDecimal> BIG_DECIMAL = new InlineArrayPropertyType<BigDecimal>(NumberType.BIG_DECIMAL, ",", true, BigDecimal[]::new);
    private final PropertyType<T> entryType;
    private final String separator;
    private final boolean useTrimAndSpaces;
    private final IntFunction<T[]> arrayProducer;

    public InlineArrayPropertyType(@NotNull PropertyType<T> entryType, @NotNull String separator, boolean useTrimAndSpaces, @NotNull IntFunction<T[]> arrayProducer) {
        this.entryType = entryType;
        this.separator = separator;
        this.useTrimAndSpaces = useTrimAndSpaces;
        this.arrayProducer = arrayProducer;
    }

    @Override
    public T @Nullable [] convert(@Nullable Object object, @NotNull ConvertErrorRecorder errorRecorder) {
        if (object instanceof String) {
            String strValue = (String)object;
            Function<String, Object> convertFunction = this.useTrimAndSpaces ? entry -> this.entryType.convert(entry.trim(), errorRecorder) : entry -> this.entryType.convert(entry, errorRecorder);
            return Arrays.stream(strValue.split(Pattern.quote(this.separator), -1)).map(entry -> ConversionUtils.convertOrLogError(entry, convertFunction, errorRecorder)).filter(Objects::nonNull).toArray(this.arrayProducer);
        }
        return null;
    }

    @NotNull
    public String toExportValue(T @NotNull [] value) {
        Object delimiter = this.useTrimAndSpaces ? this.separator + " " : this.separator;
        return Arrays.stream(value).map(this.entryType::toExportValue).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining((CharSequence)delimiter));
    }

    @NotNull
    public IntFunction<T[]> getArrayProducer() {
        return this.arrayProducer;
    }
}

