/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.builder;

import ch.jalu.configme.properties.ArrayProperty;
import ch.jalu.configme.properties.InlineArrayProperty;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.builder.PropertyBuilderUtils;
import ch.jalu.configme.properties.types.ArrayPropertyType;
import ch.jalu.configme.properties.types.InlineArrayPropertyType;
import ch.jalu.configme.properties.types.PropertyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;

public class ArrayPropertyBuilder<E, P extends Property<E[]>> {
    private String path;
    private final List<E> defaultValue = new ArrayList();
    private final BiFunction<String, E[], P> createPropertyFunction;
    private final IntFunction<E[]> arrayProducer;

    public ArrayPropertyBuilder(@NotNull BiFunction<String, E[], P> createPropertyFunction, @NotNull IntFunction<E[]> arrayProducer) {
        this.createPropertyFunction = createPropertyFunction;
        this.arrayProducer = arrayProducer;
    }

    @NotNull
    public static <E> ArrayPropertyBuilder<E, ArrayProperty<E>> arrayBuilder(@NotNull PropertyType<E> entryType, @NotNull IntFunction<E[]> arrayProducer) {
        return new ArrayPropertyBuilder<E, ArrayProperty>((path, defVal) -> new ArrayProperty<Object>((String)path, entryType, (IntFunction<Object[]>)arrayProducer, (T[])defVal), arrayProducer);
    }

    @NotNull
    public static <E> ArrayPropertyBuilder<E, ArrayProperty<E>> arrayBuilder(@NotNull ArrayPropertyType<E> arrayType) {
        return new ArrayPropertyBuilder<E, ArrayProperty>((path, defVal) -> new ArrayProperty<Object>((String)path, arrayType, (T[])defVal), arrayType.getArrayProducer());
    }

    @NotNull
    public static <E> ArrayPropertyBuilder<E, InlineArrayProperty<E>> inlineArrayBuilder(@NotNull InlineArrayPropertyType<E> inlineArrayType) {
        return new ArrayPropertyBuilder<E, InlineArrayProperty>((path, defVal) -> new InlineArrayProperty<Object>((String)path, inlineArrayType, (T[])defVal), inlineArrayType.getArrayProducer());
    }

    @NotNull
    public ArrayPropertyBuilder<E, P> path(@NotNull String path) {
        this.path = path;
        return this;
    }

    @SafeVarargs
    @NotNull
    public final ArrayPropertyBuilder<E, P> defaultValue(E ... entries) {
        PropertyBuilderUtils.verifyDefaultValueIsEmpty(this.defaultValue.isEmpty());
        this.defaultValue.addAll(Arrays.asList(entries));
        return this;
    }

    @NotNull
    public ArrayPropertyBuilder<E, P> addToDefaultValue(@NotNull E entry) {
        this.defaultValue.add(entry);
        return this;
    }

    @NotNull
    public P build() {
        PropertyBuilderUtils.requireNonNullPath(this.path);
        A[] defaultValueArray = this.defaultValue.stream().toArray(this.arrayProducer);
        return (P)((Property)this.createPropertyFunction.apply(this.path, defaultValueArray));
    }
}

