/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.processor;

import com.google.common.base.CaseFormat;
import dev.triumphteam.cmd.core.AnnotatedCommand;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Description;
import dev.triumphteam.cmd.core.annotations.Syntax;
import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.argument.keyed.ArgumentGroup;
import dev.triumphteam.cmd.core.command.InternalBranchCommand;
import dev.triumphteam.cmd.core.command.InternalCommand;
import dev.triumphteam.cmd.core.command.InternalLeafCommand;
import dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import dev.triumphteam.cmd.core.extension.CommandOptions;
import dev.triumphteam.cmd.core.extension.annotation.ProcessorTarget;
import dev.triumphteam.cmd.core.extension.command.Settings;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import dev.triumphteam.cmd.core.extension.meta.MetaKey;
import dev.triumphteam.cmd.core.extension.registry.RegistryContainer;
import dev.triumphteam.cmd.core.processor.BranchCommandProcessor;
import dev.triumphteam.cmd.core.processor.CommandProcessor;
import dev.triumphteam.cmd.core.processor.LeafCommandProcessor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootCommandProcessor<D, S, ST>
implements CommandProcessor<D, S, ST> {
    private final Object invocationInstance;
    private final String name;
    private final Syntax syntax;
    private final List<String> aliases;
    private final CommandOptions<?, ?, D, S, ST> commandOptions;
    private final RegistryContainer<D, S, ST> registryContainer;

    public RootCommandProcessor(@NotNull Object invocationInstance, @NotNull RegistryContainer<D, S, ST> registryContainer, @NotNull CommandOptions<?, ?, D, S, ST> commandOptions) {
        this.invocationInstance = invocationInstance;
        this.name = this.nameOf();
        this.aliases = this.aliasesOf();
        this.registryContainer = registryContainer;
        this.commandOptions = commandOptions;
        this.syntax = invocationInstance.getClass().getAnnotation(Syntax.class);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    @NotNull
    public CommandOptions<?, ?, D, S, ST> getCommandOptions() {
        return this.commandOptions;
    }

    @Override
    @NotNull
    public RegistryContainer<D, S, ST> getRegistryContainer() {
        return this.registryContainer;
    }

    @Override
    @Nullable
    public Syntax getSyntaxAnnotation() {
        return this.syntax;
    }

    @Override
    @NotNull
    public AnnotatedElement getAnnotatedElement() {
        return this.invocationInstance.getClass();
    }

    @Override
    @NotNull
    public CommandMeta createMeta(@NotNull @NotNull @NotNull Settings.Builder<D, S> settingsBuilder) {
        CommandMeta.Builder meta = new CommandMeta.Builder(null);
        meta.add(MetaKey.NAME, this.getName());
        meta.add(MetaKey.DESCRIPTION, this.descriptionOf());
        Class<?> klass = this.invocationInstance.getClass();
        this.processAnnotations(this.commandOptions.getCommandExtensions(), klass, ProcessorTarget.ROOT_COMMAND, meta);
        this.processCommandMeta(this.commandOptions.getCommandExtensions(), klass, ProcessorTarget.PARENT_COMMAND, meta, settingsBuilder);
        return meta.build();
    }

    @NotNull
    public List<InternalCommand<D, S, ST>> commands(@NotNull InternalCommand<D, S, ST> parentCommand) {
        Class<?> klass = this.invocationInstance.getClass();
        ArrayList<InternalCommand<D, S, ST>> subCommands = new ArrayList<InternalCommand<D, S, ST>>();
        subCommands.addAll(this.methodCommands(parentCommand, klass.getDeclaredMethods()));
        subCommands.addAll(this.classCommands(parentCommand, klass.getDeclaredClasses()));
        return subCommands;
    }

    @NotNull
    private List<InternalCommand<D, S, ST>> methodCommands(@NotNull InternalCommand<D, S, ST> parentCommand, @NotNull Method[] methods) {
        ArrayList<InternalCommand<D, S, ST>> commands = new ArrayList<InternalCommand<D, S, ST>>();
        for (Method method : methods) {
            LeafCommandProcessor<D, S, ST> processor;
            if (!Modifier.isPublic(method.getModifiers()) || (processor = new LeafCommandProcessor<D, S, ST>(this.invocationInstance, method, this.registryContainer, this.commandOptions, parentCommand.getMeta())).getName() == null) continue;
            commands.add(new InternalLeafCommand<D, S, ST>(this.invocationInstance, method, processor, parentCommand));
        }
        return commands;
    }

    @NotNull
    private List<InternalCommand<D, S, ST>> classCommands(@NotNull InternalCommand<D, S, ST> parentCommand, @NotNull Class<?>[] classes) {
        ArrayList<InternalCommand<D, S, ST>> commands = new ArrayList<InternalCommand<D, S, ST>>();
        for (Class<?> klass : classes) {
            InternalArgument argument;
            boolean hasArgument;
            BranchCommandProcessor processor;
            if (!Modifier.isPublic(klass.getModifiers()) || (processor = new BranchCommandProcessor(this.invocationInstance, klass, this.registryContainer, this.commandOptions, parentCommand.getMeta())).getName() == null) continue;
            Constructor<?>[] constructors = klass.getConstructors();
            if (constructors.length != 1) {
                throw new CommandRegistrationException("Inner command class can only have a single constructor, " + constructors.length + " found", klass);
            }
            Constructor<?> constructor = constructors[0];
            Parameter[] parameters = constructor.getParameters();
            boolean isStatic = Modifier.isStatic(klass.getModifiers());
            int arguments = isStatic ? parameters.length : parameters.length - 1;
            boolean bl = hasArgument = arguments != 0;
            if (arguments > 1) {
                throw new CommandRegistrationException("Inner command class can only have a maximum of 1 argument, " + arguments + " found", klass);
            }
            if (!hasArgument) {
                argument = null;
            } else {
                if (!"th-args-cmd".equals(processor.getName())) {
                    throw new CommandRegistrationException("Inner command class with argument must not have a name", klass);
                }
                Parameter parameter = isStatic ? parameters[0] : parameters[1];
                CommandMeta.Builder meta = new CommandMeta.Builder(null);
                this.processAnnotations(this.getCommandOptions().getCommandExtensions(), parameter, ProcessorTarget.ARGUMENT, meta);
                argument = processor.argumentFromParameter(meta.build(), parameter, Collections.emptyList(), Collections.emptyMap(), ArgumentGroup.flags(Collections.emptyList()), ArgumentGroup.named(Collections.emptyList()), 0);
                if (!(argument instanceof StringInternalArgument)) {
                    throw new CommandRegistrationException("Inner command class with argument must not be limitless, only single string argument is allowed", klass);
                }
            }
            InternalBranchCommand<D, S, ST> parent = new InternalBranchCommand<D, S, ST>(this.invocationInstance, constructor, isStatic, (StringInternalArgument)argument, processor, parentCommand);
            parent.addCommands(this.invocationInstance, this.methodCommands(parent, klass.getDeclaredMethods()));
            parent.addCommands(this.invocationInstance, this.classCommands(parent, klass.getDeclaredClasses()));
            commands.add(parent);
        }
        return commands;
    }

    @NotNull
    private String nameOf() {
        Class<?> commandClass = this.invocationInstance.getClass();
        Command commandAnnotation = commandClass.getAnnotation(Command.class);
        String name = null;
        if (commandAnnotation != null) {
            name = commandAnnotation.value();
        } else if (AnnotatedCommand.class.isAssignableFrom(commandClass)) {
            name = ((AnnotatedCommand)this.invocationInstance).getCommand();
        }
        if (name == null) {
            throw new CommandRegistrationException("No \"@" + InternalCommand.class.getSimpleName() + "\" annotation found or class doesn't extend \"" + AnnotatedCommand.class.getSimpleName() + "\"", this.invocationInstance.getClass());
        }
        if (name.isEmpty() || name.equals("th-default")) {
            throw new CommandRegistrationException("Command name must not be empty", this.invocationInstance.getClass());
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name);
    }

    @NotNull
    private List<String> aliasesOf() {
        Class<?> commandClass = this.invocationInstance.getClass();
        Command commandAnnotation = commandClass.getAnnotation(Command.class);
        List<String> aliases = null;
        if (commandAnnotation != null) {
            aliases = Arrays.asList(commandAnnotation.alias());
        } else if (AnnotatedCommand.class.isAssignableFrom(commandClass)) {
            aliases = ((AnnotatedCommand)this.invocationInstance).getAlias();
        }
        return aliases == null ? Collections.emptyList() : aliases.stream().map(name -> CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name)).collect(Collectors.toList());
    }

    @NotNull
    private String descriptionOf() {
        Class<?> commandClass = this.invocationInstance.getClass();
        Description descriptionAnnotation = commandClass.getAnnotation(Description.class);
        String description = "";
        if (descriptionAnnotation != null) {
            description = descriptionAnnotation.value();
        } else if (AnnotatedCommand.class.isAssignableFrom(commandClass)) {
            description = ((AnnotatedCommand)this.invocationInstance).getDescription();
        }
        return description;
    }
}

