/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.TypeBasedProperty;
import ch.jalu.configme.properties.types.PropertyType;
import ch.jalu.configme.properties.types.SetPropertyType;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SetProperty<E>
extends TypeBasedProperty<Set<E>> {
    @SafeVarargs
    public SetProperty(@NotNull String path, @NotNull PropertyType<E> entryType, E ... defaultValue) {
        this(path, entryType, SetProperty.newSet(defaultValue));
    }

    public SetProperty(@NotNull String path, @NotNull PropertyType<E> entryType, @NotNull Set<E> defaultValue) {
        super(path, new SetPropertyType<E>(entryType), Collections.unmodifiableSet(defaultValue));
    }

    protected SetProperty(@NotNull PropertyType<Set<E>> type, @NotNull String path, @NotNull Set<E> defaultValue) {
        super(path, type, Collections.unmodifiableSet(defaultValue));
    }

    @SafeVarargs
    public static <E> SetProperty<E> withSetType(@NotNull String path, @NotNull PropertyType<Set<E>> setType, E ... defaultValue) {
        return new SetProperty<E>(setType, path, SetProperty.newSet(defaultValue));
    }

    public static <E> SetProperty<E> withSetType(@NotNull String path, @NotNull PropertyType<Set<E>> setType, @NotNull Set<E> defaultValue) {
        return new SetProperty<E>(setType, path, defaultValue);
    }

    @NotNull
    private static <E> Set<E> newSet(E @NotNull [] array) {
        return Arrays.stream(array).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

