/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.files.types;

import com.ryderbelserion.fusion.core.files.FileManager;
import com.ryderbelserion.fusion.core.files.enums.FileType;
import com.ryderbelserion.fusion.core.files.interfaces.ICustomFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class PaperCustomFile
extends ICustomFile<PaperCustomFile, YamlConfiguration, Object, Object> {
    private final File file = this.getPath().toFile();

    public PaperCustomFile(@NotNull FileManager fileManager, @NotNull Path path, @NotNull Consumer<PaperCustomFile> consumer) {
        super(fileManager, path);
        consumer.accept(this);
    }

    @Override
    @NotNull
    public YamlConfiguration loadConfig() {
        return YamlConfiguration.loadConfiguration((File)this.file);
    }

    @Override
    public void saveConfig() throws IOException {
        ((YamlConfiguration)this.configuration).save(this.file);
    }

    @Override
    public boolean getBooleanValueWithDefault(boolean defaultValue, Object ... path) {
        return ((YamlConfiguration)this.getConfiguration()).getBoolean(Arrays.toString(path), defaultValue);
    }

    @Override
    public boolean getBooleanValue(Object ... path) {
        return this.getBooleanValueWithDefault(false, path);
    }

    @Override
    public double getDoubleValueWithDefault(double defaultValue, Object ... path) {
        return ((YamlConfiguration)this.getConfiguration()).getDouble(Arrays.toString(path), defaultValue);
    }

    @Override
    public double getDoubleValue(Object ... path) {
        return this.getDoubleValueWithDefault(0.0, path);
    }

    @Override
    public int getIntValueWithDefault(int defaultValue, Object ... path) {
        return ((YamlConfiguration)this.getConfiguration()).getInt(Arrays.toString(path), defaultValue);
    }

    @Override
    public int getIntValue(Object ... path) {
        return this.getIntValueWithDefault(0, path);
    }

    @Override
    @NotNull
    public List<String> getStringList(@NotNull List<String> defaultValue, Object ... path) {
        YamlConfiguration configuration = (YamlConfiguration)this.getConfiguration();
        List list = configuration.getStringList(Arrays.toString(path));
        return list.isEmpty() ? defaultValue : list;
    }

    @Override
    @NotNull
    public List<String> getStringList(Object ... path) {
        return this.getStringList(List.of(), path);
    }

    @Override
    public long getLongValueWithDefault(long defaultValue, Object ... path) {
        return ((YamlConfiguration)this.getConfiguration()).getLong(Arrays.toString(path), defaultValue);
    }

    @Override
    public long getLongValue(Object ... path) {
        return this.getLongValueWithDefault(0L, path);
    }

    @Override
    public boolean isLoaded() {
        return this.configuration != null;
    }

    @Override
    @NotNull
    public final FileType getFileType() {
        return FileType.PAPER;
    }
}

