/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.api;

import com.badbones69.crazyvouchers.CrazyVouchers;
import com.badbones69.crazyvouchers.api.CrazyManager;
import com.badbones69.crazyvouchers.api.builders.types.VoucherMenu;
import com.badbones69.crazyvouchers.api.enums.misc.PersistentKeys;
import com.badbones69.crazyvouchers.api.objects.Voucher;
import com.ryderbelserion.fusion.paper.builders.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class InventoryManager {
    @NotNull
    private final CrazyVouchers plugin = CrazyVouchers.get();
    @NotNull
    private final CrazyManager crazyManager = this.plugin.getCrazyManager();
    private final Map<UUID, Integer> pages = new HashMap<UUID, Integer>();
    private final ItemBuilder nextButton = (ItemBuilder)new ItemBuilder((ItemType)ItemType.ARROW).withDisplayName("<gold>Next >>");
    private final ItemBuilder backButton = (ItemBuilder)new ItemBuilder((ItemType)ItemType.ARROW).withDisplayName("<gold><< Back");
    private final int amount = 36;

    public final ItemStack getVoucher(@NotNull Player player, @NotNull Voucher voucher) {
        ItemStack itemStack = voucher.buildItem(player);
        itemStack.editPersistentDataContainer(container -> container.set(PersistentKeys.voucher_item_admin.getNamespacedKey(), PersistentDataType.STRING, (Object)voucher.getName()));
        return itemStack;
    }

    public final List<ItemStack> getPreviewItems(@NotNull Player player, int page) {
        int startIndex;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (page <= 0) {
            page = 1;
        }
        List<Voucher> vouchers = this.crazyManager.getVouchers();
        int count = vouchers.size();
        int max = this.amount;
        int endIndex = Math.min(startIndex + max, count);
        for (startIndex = page * max - max; startIndex < endIndex; ++startIndex) {
            if (startIndex >= count) continue;
            items.add(this.getVoucher(player, vouchers.get(startIndex)));
        }
        return items;
    }

    public final ItemStack getBackButton(@NotNull Player player) {
        int page = this.getPage(player) - 1;
        ItemStack itemStack = ((ItemBuilder)this.backButton.addDisplayLore("<gray>Page: <blue>" + page)).asItemStack((Audience)player);
        itemStack.editPersistentDataContainer(container -> container.set(PersistentKeys.back_button.getNamespacedKey(), PersistentDataType.INTEGER, (Object)page));
        return itemStack;
    }

    public final ItemStack getNextButton(@NotNull Player player) {
        int page = this.getPage(player) + 1;
        ItemStack itemStack = ((ItemBuilder)this.nextButton.addDisplayLore("<gray>Page: <blue>" + page)).asItemStack((Audience)player);
        itemStack.editPersistentDataContainer(container -> container.set(PersistentKeys.next_button.getNamespacedKey(), PersistentDataType.INTEGER, (Object)page));
        return itemStack;
    }

    public void remove(@NotNull Player player) {
        this.pages.remove(player.getUniqueId());
    }

    public void nextPage(@NotNull Player player, int page) {
        this.setPage(player, page);
        this.buildInventory(player, 0);
    }

    public void backPage(@NotNull Player player, int page) {
        this.setPage(player, page);
        this.buildInventory(player, 0);
    }

    public void buildInventory(@NotNull Player player, int page) {
        VoucherMenu menu = new VoucherMenu(player, 54, page <= 0 ? this.getPage(player) : page, "<red>CrazyVouchers");
        player.openInventory(menu.build().getInventory());
    }

    public int getPage(@NotNull Player player) {
        return this.pages.getOrDefault(player.getUniqueId(), 1);
    }

    public void setPage(@NotNull Player player, int page) {
        int max = this.getMaxPages();
        if (page > max) {
            page = max;
        }
        this.pages.put(player.getUniqueId(), page);
    }

    public int getMaxPages() {
        int size = this.crazyManager.getVouchers().size();
        return Math.max(1, size % this.amount > 0 ? size / this.amount + 1 : size / this.amount);
    }
}

