/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers;

import com.badbones69.crazyvouchers.Methods;
import com.badbones69.crazyvouchers.api.CrazyManager;
import com.badbones69.crazyvouchers.api.InventoryManager;
import com.badbones69.crazyvouchers.api.builders.types.VoucherMenu;
import com.badbones69.crazyvouchers.api.enums.FileSystem;
import com.badbones69.crazyvouchers.commands.features.CommandHandler;
import com.badbones69.crazyvouchers.config.ConfigManager;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import com.badbones69.crazyvouchers.listeners.FireworkDamageListener;
import com.badbones69.crazyvouchers.listeners.VoucherClickListener;
import com.badbones69.crazyvouchers.listeners.VoucherCraftListener;
import com.badbones69.crazyvouchers.listeners.VoucherMiscListener;
import com.badbones69.crazyvouchers.support.MetricsWrapper;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.files.PaperFileManager;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CrazyVouchers
extends JavaPlugin {
    private final long startTime = System.nanoTime();
    private InventoryManager inventoryManager;
    private CrazyManager crazyManager;
    private FusionPaper fusion;
    private PaperFileManager fileManager;

    @NotNull
    public static CrazyVouchers get() {
        return (CrazyVouchers)JavaPlugin.getPlugin(CrazyVouchers.class);
    }

    public void onEnable() {
        this.fusion = new FusionPaper(this);
        this.fusion.init();
        this.fileManager = this.fusion.getFileManager();
        Path path = this.getDataPath();
        ConfigManager.load(this.getDataFolder());
        FileSystem system = ConfigManager.getConfig().getProperty(ConfigKeys.file_system);
        this.fileManager.addPaperFile(path.resolve("users.yml")).addPaperFile(path.resolve("data.yml"));
        switch (system) {
            case SINGLE: {
                this.fileManager.addPaperFile(path.resolve("codes.yml")).addPaperFile(path.resolve("vouchers.yml"));
                break;
            }
            case MULTIPLE: {
                this.fileManager.addPaperFolder(path.resolve("codes")).addPaperFolder(path.resolve("vouchers"));
            }
        }
        new MetricsWrapper(4536).start();
        this.crazyManager = new CrazyManager();
        this.crazyManager.load(false);
        this.inventoryManager = new InventoryManager();
        Methods.janitor();
        PluginManager pluginManager = this.getServer().getPluginManager();
        new CommandHandler();
        List.of(new FireworkDamageListener(), new VoucherClickListener(), new VoucherCraftListener(), new VoucherMiscListener(), new VoucherMenu()).forEach(event -> pluginManager.registerEvents(event, (Plugin)this));
        this.fusion.log("info", "Done ({})", String.format(Locale.ROOT, "%.3fs", (double)(System.nanoTime() - this.startTime) / 1.0E9));
    }

    @NotNull
    public final InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    @NotNull
    public final CrazyManager getCrazyManager() {
        return this.crazyManager;
    }

    @NotNull
    public final PaperFileManager getFileManager() {
        return this.fileManager;
    }

    @NotNull
    public final FusionPaper getFusion() {
        return this.fusion;
    }
}

