/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.builders;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerBuilder {
    private final JavaPlugin plugin;
    private final Server server;
    private final String name;

    public PlayerBuilder(@NotNull JavaPlugin plugin, @NotNull String name) {
        this.plugin = plugin;
        this.server = this.plugin.getServer();
        this.name = name;
    }

    @Nullable
    public OfflinePlayer getOfflinePlayer() {
        if (this.name.isEmpty()) {
            return null;
        }
        CompletionStage future = CompletableFuture.supplyAsync(() -> this.server.getOfflinePlayer(this.name)).thenApply(OfflinePlayer::getUniqueId);
        return this.server.getOfflinePlayer((UUID)((CompletableFuture)future).join());
    }

    @Nullable
    public Player getPlayer() {
        if (this.name.isEmpty()) {
            return null;
        }
        return this.server.getPlayerExact(this.name);
    }
}

