/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.config;

import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.SettingsManagerBuilder;
import ch.jalu.configme.configurationdata.ConfigurationDataBuilder;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import com.badbones69.crazyvouchers.config.migrate.ConfigMigration;
import com.badbones69.crazyvouchers.config.migrate.LocaleMigration;
import com.badbones69.crazyvouchers.config.types.ConfigKeys;
import com.badbones69.crazyvouchers.config.types.locale.CommandKeys;
import com.badbones69.crazyvouchers.config.types.locale.MessageKeys;
import com.badbones69.crazyvouchers.config.types.locale.MiscKeys;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    private static SettingsManager config;
    private static SettingsManager messages;

    public static void load(@NotNull File dataFolder) {
        YamlFileResourceOptions builder = YamlFileResourceOptions.builder().indentationSize(2).build();
        File configFile = new File(dataFolder, "config.yml");
        config = SettingsManagerBuilder.withYamlFile(configFile, builder).migrationService(new ConfigMigration()).configurationData(ConfigurationDataBuilder.createConfiguration(ConfigKeys.class)).create();
        File oldFile = new File(dataFolder, "Messages.yml");
        File localeDir = new File(dataFolder, "locale");
        if (oldFile.exists()) {
            if (!localeDir.exists()) {
                localeDir.mkdirs();
            }
            oldFile.renameTo(new File(localeDir, "en-US.yml"));
        }
        if (!localeDir.exists()) {
            localeDir.mkdirs();
        }
        File messagesFile = new File(localeDir, config.getProperty(ConfigKeys.locale_file) + ".yml");
        messages = SettingsManagerBuilder.withYamlFile(messagesFile, builder).migrationService(new LocaleMigration()).configurationData(MessageKeys.class, MiscKeys.class, CommandKeys.class).create();
    }

    public static void refresh() {
        config.reload();
        messages.reload();
    }

    @NotNull
    public static SettingsManager getConfig() {
        return config;
    }

    @NotNull
    public static SettingsManager getMessages() {
        return messages;
    }
}

