/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.typeimpl;

import ch.jalu.typeresolver.CommonTypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Class<?> rawType;
    private final Type ownerType;
    private final Type[] actualTypeArguments;

    public ParameterizedTypeImpl(Class<?> rawType, @Nullable Type ownerType, Type ... actualTypeArguments) {
        this.rawType = rawType;
        this.ownerType = ownerType;
        this.actualTypeArguments = actualTypeArguments;
    }

    public ParameterizedTypeImpl(ParameterizedType parameterizedType) {
        this.rawType = CommonTypeUtils.getRawType(parameterizedType);
        this.ownerType = parameterizedType.getOwnerType();
        this.actualTypeArguments = parameterizedType.getActualTypeArguments();
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    @Nullable
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ParameterizedType) {
            ParameterizedType that = (ParameterizedType)obj;
            return Objects.equals(this.ownerType, that.getOwnerType()) && Objects.equals(this.rawType, that.getRawType()) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ownerType != null) {
            sb.append(this.ownerType.getTypeName()).append("$").append(this.rawType.getSimpleName());
        } else {
            sb.append(this.rawType.getName());
        }
        if (this.actualTypeArguments.length > 0) {
            sb.append("<");
            for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.actualTypeArguments[i].getTypeName());
            }
            sb.append(">");
        }
        return sb.toString();
    }
}

