/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.commands.features;

import com.badbones69.crazyvouchers.CrazyVouchers;
import com.badbones69.crazyvouchers.api.CrazyManager;
import com.badbones69.crazyvouchers.api.enums.misc.PermissionKeys;
import com.badbones69.crazyvouchers.api.objects.Voucher;
import com.badbones69.crazyvouchers.api.objects.VoucherCode;
import com.badbones69.crazyvouchers.commands.features.admin.CommandGive;
import com.badbones69.crazyvouchers.commands.features.admin.CommandMenu;
import com.badbones69.crazyvouchers.commands.features.admin.CommandMigrate;
import com.badbones69.crazyvouchers.commands.features.admin.CommandRedeem;
import com.badbones69.crazyvouchers.commands.features.admin.CommandTypes;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.enums.MigrationType;
import com.badbones69.crazyvouchers.commands.features.base.CommandHelp;
import com.badbones69.crazyvouchers.commands.features.base.CommandReload;
import com.badbones69.crazyvouchers.commands.features.relations.ArgumentRelations;
import com.ryderbelserion.fusion.paper.builders.PlayerBuilder;
import dev.triumphteam.cmd.bukkit.BukkitCommandManager;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;

public class CommandHandler {
    @NotNull
    private final CrazyVouchers plugin = CrazyVouchers.get();
    @NotNull
    private final CrazyManager crazyManager = this.plugin.getCrazyManager();
    @NotNull
    private final BukkitCommandManager<CommandSender> commandManager = BukkitCommandManager.create((Plugin)this.plugin);

    public CommandHandler() {
        this.load();
    }

    public void load() {
        Server server = this.plugin.getServer();
        PluginManager pluginManager = server.getPluginManager();
        new ArgumentRelations(this.commandManager).build();
        this.commandManager.registerSuggestion(SuggestionKey.of("players"), sender -> server.getOnlinePlayers().stream().map(Player::getName).toList());
        this.commandManager.registerSuggestion(SuggestionKey.of("numbers"), sender -> {
            ArrayList<String> numbers = new ArrayList<String>();
            for (int i = 1; i <= 100; ++i) {
                numbers.add(String.valueOf(i));
            }
            return numbers;
        });
        this.commandManager.registerSuggestion(SuggestionKey.of("doubles"), sender -> {
            ArrayList<String> numbers = new ArrayList<String>();
            for (int count = 0; count <= 1000; ++count) {
                double x = (double)count / 10.0;
                numbers.add(String.valueOf(x));
            }
            return numbers;
        });
        this.commandManager.registerSuggestion(SuggestionKey.of("codes"), sender -> {
            List<VoucherCode> codes = this.crazyManager.getVoucherCodes();
            ArrayList<String> suggestions = new ArrayList<String>();
            Object patt0$temp = sender.getSender();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                if (PermissionKeys.crazyvouchers_admin.hasPermission(player)) {
                    suggestions.addAll(codes.stream().map(VoucherCode::getCode).toList());
                    return suggestions;
                }
                codes.forEach(code -> {
                    String message;
                    List<String> commands;
                    List<String> permissions;
                    boolean blacklist = code.useBlacklistPermissions();
                    boolean whitelist = code.useWhiteListPermissions();
                    List<String> list = blacklist ? code.getBlacklistPermissions() : (permissions = whitelist ? code.getWhitelistPermissions() : List.of());
                    List<String> list2 = blacklist ? code.getBlacklistCommands() : (commands = whitelist ? code.getWhitelistCommands() : List.of());
                    String string = blacklist ? code.getBlacklistMessage() : (message = whitelist ? code.getWhitelistWorldMessage() : "");
                    if (code.hasPermission(player, permissions, commands, new HashMap<String, String>(), message, "")) {
                        suggestions.add(code.getCode());
                    }
                });
            }
            return suggestions;
        });
        this.commandManager.registerSuggestion(SuggestionKey.of("vouchers"), sender -> {
            Player player;
            List<Voucher> codes = this.crazyManager.getVouchers();
            ArrayList<String> suggestions = new ArrayList<String>();
            Object patt0$temp = sender.getSender();
            if (patt0$temp instanceof Player && PermissionKeys.crazyvouchers_admin.hasPermission(player = (Player)patt0$temp)) {
                suggestions.addAll(codes.stream().map(Voucher::getStrippedName).toList());
                return suggestions;
            }
            return suggestions;
        });
        this.commandManager.registerSuggestion(SuggestionKey.of("migrators"), sender -> {
            ArrayList<String> migrators = new ArrayList<String>();
            for (MigrationType value : MigrationType.values()) {
                String name = value.getName();
                migrators.add(name);
            }
            return migrators;
        });
        this.commandManager.registerArgument(PlayerBuilder.class, (sender, context) -> new PlayerBuilder(this.plugin, context));
        List.of(new CommandGive(), new CommandMenu(), new CommandMigrate(), new CommandRedeem(), new CommandTypes(), new CommandHelp(), new CommandReload()).forEach(this.commandManager::registerCommand);
        for (PermissionKeys key : PermissionKeys.values()) {
            String node = key.getPermission();
            Permission current = pluginManager.getPermission(node);
            if (current != null) continue;
            Permission permission = new Permission(node, key.getDescription(), key.isDefault(), key.getChildren());
            pluginManager.addPermission(permission);
        }
    }

    @NotNull
    public final BukkitCommandManager<CommandSender> getCommandManager() {
        return this.commandManager;
    }
}

