/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.classutil;

import ch.jalu.typeresolver.EnumUtils;
import ch.jalu.typeresolver.array.ArrayClassProperties;
import ch.jalu.typeresolver.classutil.ClassType;
import ch.jalu.typeresolver.classutil.ClassTypeCallback;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static boolean classExists(String name) {
        return ClassUtils.tryLoadClass(name).isPresent();
    }

    public static Optional<Class<?>> tryLoadClass(String name) {
        try {
            return Optional.of(Class.forName(name));
        }
        catch (ClassNotFoundException ignored) {
            return Optional.empty();
        }
    }

    public static Class<?> loadClassOrThrow(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class '" + name + "' could not be loaded", e);
        }
    }

    public static <T> Optional<Class<? extends T>> asSubclassIfPossible(Class<?> classToInspect, Class<T> parent) {
        if (parent.isAssignableFrom(classToInspect)) {
            return Optional.of(classToInspect);
        }
        return Optional.empty();
    }

    public static String getClassName(@Nullable Object object) {
        return object == null ? "null" : object.getClass().getName();
    }

    @Nullable
    public static Class<?> getSemanticType(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Enum) {
            return ((Enum)object).getDeclaringClass();
        }
        if (object instanceof Annotation && Proxy.isProxyClass(object.getClass())) {
            return ((Annotation)object).annotationType();
        }
        return object.getClass();
    }

    public static String getSemanticName(@Nullable Object object) {
        Class<?> semanticType = ClassUtils.getSemanticType(object);
        return ClassUtils.createNameOfSemanticType(semanticType);
    }

    public static String getSemanticName(@Nullable Class<?> clazz) {
        return EnumUtils.getAssociatedEnumType(clazz).map(ClassUtils::createNameOfSemanticType).orElseGet(() -> ClassUtils.createNameOfSemanticType(clazz));
    }

    public static boolean isRegularJavaClass(@Nullable Class<?> clazz) {
        return ClassUtils.getType(clazz) == ClassType.REGULAR_CLASS;
    }

    public static ClassType getType(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return clazz.isEnum() ? ClassType.ENUM : ClassType.ENUM_ENTRY;
        }
        if (clazz.isPrimitive()) {
            return ClassType.PRIMITIVE;
        }
        if (Proxy.isProxyClass(clazz)) {
            return ClassType.PROXY_CLASS;
        }
        if (clazz.isAnnotation()) {
            return ClassType.ANNOTATION;
        }
        if (clazz.isInterface()) {
            return ClassType.INTERFACE;
        }
        if (clazz.isArray()) {
            return ClassType.ARRAY;
        }
        return ClassType.REGULAR_CLASS;
    }

    @Nullable
    public static <R> R processClassByType(@Nullable Class<?> clazz, ClassTypeCallback<? extends R> typeCallback) {
        ClassType type = ClassUtils.getType(clazz);
        if (type == null) {
            return null;
        }
        switch (type) {
            case ENUM: {
                return typeCallback.forEnum(clazz);
            }
            case ENUM_ENTRY: {
                return typeCallback.forEnumEntry(clazz.getEnclosingClass(), clazz);
            }
            case ANNOTATION: {
                return typeCallback.forAnnotation(clazz);
            }
            case PRIMITIVE: {
                return typeCallback.forPrimitiveType(clazz);
            }
            case ARRAY: {
                return typeCallback.forArrayType(clazz);
            }
            case INTERFACE: {
                return typeCallback.forInterface(clazz);
            }
            case PROXY_CLASS: {
                return typeCallback.forProxyClass(clazz);
            }
            case REGULAR_CLASS: {
                return typeCallback.forRegularClass(clazz);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
    }

    private static String createNameOfSemanticType(@Nullable Class<?> semanticType) {
        if (semanticType == null) {
            return "null";
        }
        if (semanticType.isAnnotation()) {
            return "@" + ClassUtils.getNameWithoutPackage(semanticType);
        }
        if (semanticType.isArray()) {
            ArrayClassProperties arrayProperties = new ArrayClassProperties(semanticType);
            StringBuilder stringBuilder = new StringBuilder(ClassUtils.getNameWithoutPackage(arrayProperties.getComponentType()));
            ClassUtils.appendArraySuffix(arrayProperties.getDimension(), stringBuilder);
            return stringBuilder.toString();
        }
        return ClassUtils.getNameWithoutPackage(semanticType);
    }

    private static String getNameWithoutPackage(Class<?> clazz) {
        String name = clazz.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static void appendArraySuffix(int dimension, StringBuilder stringBuilder) {
        for (int i = 0; i < dimension; ++i) {
            stringBuilder.append("[]");
        }
    }
}

