/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyvouchers.commands.features.admin;

import com.badbones69.crazyvouchers.api.enums.config.Messages;
import com.badbones69.crazyvouchers.commands.BaseCommand;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.enums.MigrationType;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.types.VoucherDeprecated;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.types.VoucherFileMigrator;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.types.VoucherNbtMigrator;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.types.VoucherSwitchMigrator;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.types.deprecation.LegacyColorMigrator;
import com.badbones69.crazyvouchers.commands.features.admin.migrate.types.deprecation.NewItemMigrator;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Flag;
import dev.triumphteam.cmd.core.annotations.Syntax;
import dev.triumphteam.cmd.core.argument.keyed.Flags;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class CommandMigrate
extends BaseCommand {
    @Command(value="migrate")
    @Permission(value={"crazyvouchers.migrate"}, def=PermissionDefault.OP)
    @Syntax(value="/crazyvouchers migrate -mt [type]")
    @Flag(flag="mt", longFlag="migration_type", argument=String.class, suggestion="migrators")
    public void migrate(CommandSender sender, Flags flags) {
        boolean hasFlag = flags.hasFlag("mt");
        if (!hasFlag) {
            Messages.lacking_flag.sendMessage((Audience)sender, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("{flag}", "-mt");
                    this.put("{usage}", "/crazyvouchers migrate -mt [type]");
                }
            });
            return;
        }
        Optional<String> key = flags.getFlagValue("mt");
        if (key.isEmpty()) {
            Messages.migration_not_available.sendMessage((Audience)sender);
            return;
        }
        MigrationType type = MigrationType.fromName(key.get());
        if (type == null) {
            Messages.migration_not_available.sendMessage((Audience)sender);
            return;
        }
        switch (type) {
            case VOUCHERS_SWITCH: {
                new VoucherSwitchMigrator(sender).run();
                break;
            }
            case VOUCHERS_NBT_API: {
                if (!(sender instanceof Player)) {
                    Messages.player_only.sendMessage((Audience)sender);
                    return;
                }
                new VoucherNbtMigrator(sender).run();
                break;
            }
            case NEW_ITEM_FORMAT: {
                new NewItemMigrator(sender).run();
                break;
            }
            case VOUCHERS_COLOR: {
                new LegacyColorMigrator(sender).run();
                break;
            }
            case VOUCHERS_RENAME: {
                new VoucherFileMigrator(sender, type).run();
                break;
            }
            case VOUCHERS_DEPRECATED: {
                new VoucherDeprecated(sender).run();
            }
        }
    }
}

