/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.migration.version;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.migration.version.VersionMigration;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VersionMigrationService
implements MigrationService {
    private final Property<Integer> versionProperty;
    private final Map<Integer, VersionMigration> migrationsByStartVersion;

    public VersionMigrationService(@NotNull Property<Integer> versionProperty, @NotNull Iterable<VersionMigration> migrations) {
        this.versionProperty = versionProperty;
        this.migrationsByStartVersion = this.validateAndGroupMigrationsByFromVersion(migrations);
    }

    public VersionMigrationService(@NotNull Property<Integer> versionProperty, VersionMigration ... migrations) {
        this(versionProperty, Arrays.asList(migrations));
    }

    @Override
    public boolean checkAndMigrate(@NotNull PropertyReader reader, @NotNull ConfigurationData configurationData) {
        return this.performMigrations(reader, configurationData) || !configurationData.areAllValuesValidInResource();
    }

    @NotNull
    protected final Property<Integer> getVersionProperty() {
        return this.versionProperty;
    }

    @NotNull
    protected final Map<Integer, VersionMigration> getMigrationsByStartVersion() {
        return this.migrationsByStartVersion;
    }

    protected boolean performMigrations(@NotNull PropertyReader reader, @NotNull ConfigurationData configurationData) {
        int configVersion;
        int readConfigVersion = this.versionProperty.determineValue(reader).getValue();
        if (readConfigVersion == (configVersion = this.versionProperty.getDefaultValue().intValue())) {
            return false;
        }
        this.runApplicableMigrations(readConfigVersion, reader, configurationData);
        configurationData.setValue(this.versionProperty, configVersion);
        return true;
    }

    protected int runApplicableMigrations(int readConfigVersion, @NotNull PropertyReader reader, @NotNull ConfigurationData configurationData) {
        int updatedVersion = readConfigVersion;
        VersionMigration migration = this.migrationsByStartVersion.get(readConfigVersion);
        while (migration != null) {
            migration.migrate(reader, configurationData);
            updatedVersion = migration.targetVersion();
            migration = this.migrationsByStartVersion.get(updatedVersion);
        }
        return updatedVersion;
    }

    @NotNull
    protected Map<Integer, VersionMigration> validateAndGroupMigrationsByFromVersion(@NotNull Iterable<VersionMigration> migrations) {
        HashMap<Integer, VersionMigration> migrationsByStartVersion = new HashMap<Integer, VersionMigration>();
        for (VersionMigration migration : migrations) {
            this.validateVersions(migration);
            int fromVersion = migration.fromVersion();
            if (migrationsByStartVersion.put(fromVersion, migration) == null) continue;
            throw new IllegalArgumentException("Multiple migrations were provided for start version " + fromVersion);
        }
        return migrationsByStartVersion;
    }

    protected void validateVersions(@NotNull VersionMigration migration) {
        if (migration.targetVersion() > this.versionProperty.getDefaultValue()) {
            throw new IllegalArgumentException("The migration from version " + migration.fromVersion() + " to version " + migration.targetVersion() + " has an invalid target version. Current configuration version is: " + String.valueOf(this.versionProperty.getDefaultValue()));
        }
        if (migration.fromVersion() >= migration.targetVersion()) {
            throw new IllegalArgumentException("A migration from version " + migration.fromVersion() + " to version " + migration.targetVersion() + " was supplied, but it is expected that the target version be larger than the start version");
        }
    }
}

