/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.files;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.core.files.FileManager;
import libs.com.ryderbelserion.fusion.core.files.enums.FileAction;
import libs.com.ryderbelserion.fusion.core.files.interfaces.ICustomFile;
import libs.com.ryderbelserion.fusion.paper.FusionPaper;
import libs.com.ryderbelserion.fusion.paper.files.types.NbtCustomFile;
import libs.com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import org.jetbrains.annotations.NotNull;

public class PaperFileManager
extends FileManager {
    private final FusionPaper fusion;

    public PaperFileManager(@NotNull FusionPaper fusion) {
        super(fusion);
        this.fusion = fusion;
    }

    public final PaperFileManager addNbtFile(@NotNull Path path) {
        if (this.files.containsKey(path)) {
            return this;
        }
        this.addFile(path, new NbtCustomFile(this.fusion.getPlugin(), this, path));
        return this;
    }

    public final PaperFileManager addNbtFolder(@NotNull Path folder) {
        this.extractFolder(folder.getFileName().toString(), folder.getParent());
        for (Path path : this.fusion.getFiles(folder, ".nbt", this.fusion.getDepth())) {
            this.addNbtFile(path);
        }
        return this;
    }

    public final Optional<NbtCustomFile> getNbtFile(@NotNull Path path) {
        return this.getFile(path).map(NbtCustomFile.class::cast);
    }

    public final PaperFileManager addPaperFile(@NotNull Path path, @NotNull Consumer<PaperCustomFile> consumer) {
        if (this.files.containsKey(path)) {
            ((ICustomFile)this.files.get(path)).load();
            return this;
        }
        this.addFile(path, (ICustomFile)new PaperCustomFile(this, path, consumer).load());
        return this;
    }

    public final PaperFileManager addPaperFile(@NotNull Path path) {
        return this.addPaperFile(path, consumer -> consumer.addAction(FileAction.EXTRACT_FILE));
    }

    public PaperFileManager addPaperFile(@NotNull PaperCustomFile customFile) {
        this.addFile(customFile.getPath(), customFile);
        return this;
    }

    public PaperFileManager savePaperFile(@NotNull PaperCustomFile customFile) {
        customFile.save();
        return this;
    }

    public PaperFileManager addPaperFolder(@NotNull Path folder, @NotNull Consumer<PaperCustomFile> consumer) {
        this.extractFolder(folder.getFileName().toString(), folder.getParent());
        for (Path path : this.fusion.getFiles(folder, ".yml", this.fusion.getDepth())) {
            this.addPaperFile(path, consumer);
        }
        return this;
    }

    public PaperFileManager addPaperFolder(@NotNull Path folder) {
        return this.addPaperFolder(folder, consumer -> consumer.addAction(FileAction.EXTRACT_FOLDER));
    }

    @NotNull
    public Optional<PaperCustomFile> getPaperFile(@NotNull Path path) {
        return this.getFile(path).map(PaperCustomFile.class::cast);
    }
}

