/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.builders.types;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.BannerPatternLayers;
import libs.com.ryderbelserion.fusion.paper.builders.BaseItemBuilder;
import libs.com.ryderbelserion.fusion.paper.utils.ColorUtils;
import libs.com.ryderbelserion.fusion.paper.utils.ItemUtils;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PatternBuilder
extends BaseItemBuilder<PatternBuilder> {
    private final BannerPatternLayers.Builder builder = BannerPatternLayers.bannerPatternLayers();

    public PatternBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    @NotNull
    public PatternBuilder addPattern(@NotNull Pattern pattern) {
        this.builder.add(pattern);
        return this;
    }

    @NotNull
    public PatternBuilder addPattern(@NotNull String pattern, @NotNull String dye) {
        PatternType type = ItemUtils.getPatternType(pattern.toLowerCase());
        if (type == null) {
            return this;
        }
        return this.addPattern(new Pattern(ColorUtils.getDyeColor(dye), type));
    }

    @Override
    @NotNull
    public PatternBuilder build() {
        this.itemStack.setData(DataComponentTypes.BANNER_PATTERNS, (Object)((BannerPatternLayers)this.builder.build()));
        return this;
    }
}

