/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.files.types;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.files.FileManager;
import libs.com.ryderbelserion.fusion.core.files.enums.FileType;
import libs.com.ryderbelserion.fusion.core.files.interfaces.ICustomFile;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public final class YamlCustomFile
extends ICustomFile<YamlCustomFile, CommentedConfigurationNode, YamlConfigurationLoader, ConfigurationOptions> {
    public YamlCustomFile(@NotNull FileManager fileManager, @NotNull Path path, @NotNull Consumer<YamlCustomFile> consumer) {
        super(fileManager, path);
        this.options = ConfigurationOptions.defaults();
        consumer.accept(this);
        this.loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.getPath())).defaultOptions((ConfigurationOptions)this.getOptions())).build();
    }

    @Override
    @NotNull
    public CommentedConfigurationNode loadConfig() throws IOException {
        return (CommentedConfigurationNode)((YamlConfigurationLoader)this.loader).load();
    }

    @Override
    public void saveConfig() throws IOException {
        ((YamlConfigurationLoader)this.loader).save((ConfigurationNode)this.configuration);
    }

    @Override
    @NotNull
    public String getStringValueWithDefault(@NotNull String defaultValue, Object ... path) {
        return ((CommentedConfigurationNode)((CommentedConfigurationNode)this.getConfiguration()).node(path)).getString(defaultValue);
    }

    @Override
    public boolean getBooleanValueWithDefault(boolean defaultValue, Object ... path) {
        return ((CommentedConfigurationNode)((CommentedConfigurationNode)this.getConfiguration()).node(path)).getBoolean(defaultValue);
    }

    @Override
    public double getDoubleValueWithDefault(double defaultValue, Object ... path) {
        return ((CommentedConfigurationNode)((CommentedConfigurationNode)this.getConfiguration()).node(path)).getDouble(defaultValue);
    }

    @Override
    public long getLongValueWithDefault(long defaultValue, Object ... path) {
        return ((CommentedConfigurationNode)((CommentedConfigurationNode)this.getConfiguration()).node(path)).getLong(defaultValue);
    }

    @Override
    public int getIntValueWithDefault(int defaultValue, Object ... path) {
        return ((CommentedConfigurationNode)((CommentedConfigurationNode)this.getConfiguration()).node(path)).getInt(defaultValue);
    }

    @Override
    @NotNull
    public List<String> getStringList(@NotNull List<String> defaultValue, Object ... path) {
        CommentedConfigurationNode node = (CommentedConfigurationNode)((CommentedConfigurationNode)this.getConfiguration()).node(path);
        try {
            List list = node.getList(String.class);
            if (list != null) {
                return list;
            }
            return defaultValue;
        }
        catch (SerializationException exception) {
            throw new FusionException(String.format("Failed to serialize %s!", node.path()), (Exception)((Object)exception));
        }
    }

    @Override
    public boolean isLoaded() {
        return this.configuration != null;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return FileType.YAML;
    }
}

