/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.files.types;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.core.files.FileManager;
import libs.com.ryderbelserion.fusion.core.files.enums.FileType;
import libs.com.ryderbelserion.fusion.core.files.interfaces.ICustomFile;
import org.jetbrains.annotations.NotNull;

public final class LogCustomFile
extends ICustomFile<LogCustomFile, LogCustomFile, Object, Object> {
    public LogCustomFile(@NotNull FileManager fileManager, @NotNull Path path, @NotNull Consumer<LogCustomFile> consumer) {
        super(fileManager, path);
        consumer.accept(this);
    }

    @Override
    @NotNull
    public LogCustomFile loadConfig() throws IOException {
        Files.createFile(this.getPath(), new FileAttribute[0]);
        return this;
    }

    @Override
    public void saveConfig(@NotNull String content) {
        if (content.isEmpty()) {
            this.saveConfig();
            return;
        }
        this.fileManager.compressFile(this.getPath(), content);
    }

    @Override
    public void saveConfig() {
        this.fileManager.compressFile(this.getPath());
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return FileType.LOG;
    }
}

