/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.api.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import libs.com.ryderbelserion.fusion.core.FusionCore;
import libs.com.ryderbelserion.fusion.core.FusionKey;
import libs.com.ryderbelserion.fusion.core.api.interfaces.mods.IMod;
import libs.com.ryderbelserion.fusion.core.api.support.ModSupport;
import libs.com.ryderbelserion.fusion.core.api.support.objects.Mod;
import org.jetbrains.annotations.NotNull;

public class ModManager {
    private final FusionCore fusion;
    public Map<FusionKey, IMod> mods = new HashMap<FusionKey, IMod>();

    public ModManager(@NotNull FusionCore fusion) {
        this.fusion = fusion;
    }

    public void addMod(@NotNull FusionKey key, @NotNull Mod mod) {
        this.mods.putIfAbsent(key, mod.accept(consumer -> {
            consumer.setFusion(this.fusion);
            consumer.setKey(key);
        }));
    }

    public void removeMod(@NotNull FusionKey key) {
        if (!this.mods.containsKey(key) || ModSupport.dependencies.contains(key)) {
            return;
        }
        this.mods.remove(key);
    }

    @NotNull
    public final Map<FusionKey, IMod> getMods() {
        return Collections.unmodifiableMap(this.mods);
    }

    public IMod getMod(@NotNull FusionKey key) {
        return this.mods.get(key);
    }
}

