/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core;

import libs.com.ryderbelserion.fusion.core.api.interfaces.IFusionKey;
import org.jetbrains.annotations.NotNull;

public class FusionKey
extends IFusionKey {
    private final String namespace;
    private final String value;

    public FusionKey(@NotNull String namespace, @NotNull String value) {
        this.namespace = namespace;
        this.value = value;
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public String asString() {
        return this.namespace + ":" + this.value;
    }

    public static FusionKey key(@NotNull String namespace, @NotNull String value) {
        return new FusionKey(namespace, value);
    }

    public static FusionKey key(@NotNull String value) {
        if (!value.contains(":")) {
            return FusionKey.key(FusionKey.getFusionNamespace(), value);
        }
        String[] split = value.split(":");
        return new FusionKey(split[0], split[1]);
    }

    public static String getFusionNamespace() {
        return "fusion";
    }
}

