/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.extension;

import dev.triumphteam.cmd.core.CommandManager;
import dev.triumphteam.cmd.core.extension.CommandExtensions;
import dev.triumphteam.cmd.core.extension.ExtensionBuilder;
import dev.triumphteam.cmd.core.extension.sender.SenderExtension;
import dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CommandOptions<O extends CommandOptions<O, M, D, S, ST>, M extends CommandManager<M, O, D, S, ST>, D, S, ST> {
    private final CommandExtensions<D, S, ST> commandExtensions;
    private final boolean suggestLowercaseEnum;
    private final Consumer<M> setup;
    private final SuggestionMethod suggestionMethod;

    public CommandOptions(@NotNull SenderExtension<D, S> senderExtension, @NotNull Builder<?, M, O, D, S, ST> builder) {
        this.commandExtensions = ((Builder)builder).extensionBuilder.build(senderExtension);
        this.suggestLowercaseEnum = ((Builder)builder).suggestLowercaseEnum;
        this.setup = ((Builder)builder).setup;
        this.suggestionMethod = ((Builder)builder).suggestionMethod;
    }

    @NotNull
    public CommandExtensions<D, S, ST> getCommandExtensions() {
        return this.commandExtensions;
    }

    @NotNull
    public Consumer<M> getSetup() {
        return this.setup;
    }

    @NotNull
    public SuggestionMethod getDefaultSuggestionMethod() {
        return this.suggestionMethod;
    }

    public boolean suggestLowercaseEnum() {
        return this.suggestLowercaseEnum;
    }

    public static abstract class Builder<B extends Builder<B, M, O, D, S, ST>, M extends CommandManager<M, O, D, S, ST>, O extends CommandOptions<O, M, D, S, ST>, D, S, ST> {
        private final ExtensionBuilder<D, S, ST> extensionBuilder = new ExtensionBuilder();
        private Consumer<M> setup = setup -> {};
        private boolean suggestLowercaseEnum = false;
        private SuggestionMethod suggestionMethod = SuggestionMethod.STARTS_WITH;

        @NotNull
        protected abstract B getThis();

        @Contract(value="_ -> this")
        @NotNull
        public B setup(@NotNull Consumer<M> consumer) {
            this.setup = consumer;
            return this.getThis();
        }

        @Contract(value="_ -> this")
        @NotNull
        public B extensions(@NotNull Consumer<ExtensionBuilder<D, S, ST>> consumer) {
            consumer.accept(this.extensionBuilder);
            return this.getThis();
        }

        @Contract(value=" -> this")
        @NotNull
        public B suggestLowercaseEnum() {
            this.suggestLowercaseEnum = true;
            return this.getThis();
        }

        @Contract(value="_ -> this")
        @NotNull
        public B defaultSuggestionMethod(@NotNull SuggestionMethod suggestionMethod) {
            this.suggestionMethod = suggestionMethod;
            return this.getThis();
        }
    }
}

