/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument.keyed;

import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.LimitlessInternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.argument.keyed.Argument;
import dev.triumphteam.cmd.core.argument.keyed.ArgumentGroup;
import dev.triumphteam.cmd.core.argument.keyed.ArgumentParser;
import dev.triumphteam.cmd.core.argument.keyed.ArgumentValue;
import dev.triumphteam.cmd.core.argument.keyed.EmptyArgumentValue;
import dev.triumphteam.cmd.core.argument.keyed.Flag;
import dev.triumphteam.cmd.core.argument.keyed.Flags;
import dev.triumphteam.cmd.core.argument.keyed.KeyedArguments;
import dev.triumphteam.cmd.core.argument.keyed.SimpleArgumentValue;
import dev.triumphteam.cmd.core.command.ArgumentInput;
import dev.triumphteam.cmd.core.extension.InternalArgumentResult;
import dev.triumphteam.cmd.core.extension.SuggestionMapper;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import dev.triumphteam.cmd.core.suggestion.EmptySuggestion;
import dev.triumphteam.cmd.core.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeyedInternalArgument<S, ST>
extends LimitlessInternalArgument<S, ST> {
    private final Map<Flag, StringInternalArgument<S, ST>> flagInternalArguments;
    private final Map<Argument, StringInternalArgument<S, ST>> argumentInternalArguments;
    private final SuggestionMapper<ST> mapper;
    private final ArgumentParser argumentParser;

    public KeyedInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull Map<Flag, StringInternalArgument<S, ST>> flagInternalArguments, @NotNull Map<Argument, StringInternalArgument<S, ST>> argumentInternalArguments, @NotNull ArgumentGroup<Flag> flagGroup, @NotNull ArgumentGroup<Argument> argumentGroup, @NotNull SuggestionMapper<ST> mapper) {
        super(meta, name, description, Flags.class, new EmptySuggestion(), null, true);
        this.flagInternalArguments = flagInternalArguments;
        this.argumentInternalArguments = argumentInternalArguments;
        this.mapper = mapper;
        this.argumentParser = new ArgumentParser(flagGroup, argumentGroup);
    }

    @Override
    @NotNull
    public InternalArgumentResult resolve(@NotNull S sender, @NotNull ArgumentInput input) {
        ArgumentParser.Result result = this.argumentParser.parse(Arrays.asList(input.getInput().split(" ")));
        HashMap<String, ArgumentValue> arguments = new HashMap<String, ArgumentValue>();
        for (Map.Entry<Argument, String> entry : result.getNamedArguments().entrySet()) {
            Argument argument = entry.getKey();
            String raw = entry.getValue();
            StringInternalArgument<S, ST> internalArgument = this.argumentInternalArguments.get(argument);
            if (internalArgument == null) continue;
            InternalArgumentResult resolved = internalArgument.resolve(sender, new ArgumentInput(entry.getValue()));
            if (resolved instanceof InternalArgumentResult.Invalid) {
                return resolved;
            }
            if (!(resolved instanceof InternalArgumentResult.Valid)) continue;
            Object resolvedValue = ((InternalArgumentResult.Valid)resolved).getValue();
            arguments.put(argument.getName(), new SimpleArgumentValue(raw, resolvedValue));
        }
        HashMap<String, ArgumentValue> flags = new HashMap<String, ArgumentValue>();
        for (Map.Entry<Flag, String> entry : result.getFlags().entrySet()) {
            Flag flag = entry.getKey();
            String raw = entry.getValue();
            if (!flag.hasArgument()) {
                flags.put(flag.getFlag(), EmptyArgumentValue.INSTANCE);
                flags.put(flag.getLongFlag(), EmptyArgumentValue.INSTANCE);
                continue;
            }
            StringInternalArgument<S, ST> internalArgument = this.flagInternalArguments.get(flag);
            if (internalArgument == null) continue;
            InternalArgumentResult resolved = internalArgument.resolve(sender, new ArgumentInput(entry.getValue()));
            if (resolved instanceof InternalArgumentResult.Invalid) {
                return resolved;
            }
            if (!(resolved instanceof InternalArgumentResult.Valid)) continue;
            Object resolvedValue = ((InternalArgumentResult.Valid)resolved).getValue();
            SimpleArgumentValue argumentValue = new SimpleArgumentValue(raw, resolvedValue);
            flags.put(flag.getFlag(), argumentValue);
            flags.put(flag.getLongFlag(), argumentValue);
        }
        return InternalArgument.valid(new KeyedArguments(arguments, flags, result.getNonTokens()));
    }

    @Override
    @NotNull
    public List<ST> suggestions(@NotNull S sender, @NotNull String current, @NotNull List<String> arguments, @NotNull Map<String, String> argumentsMap) {
        ArgumentParser.Result result = this.argumentParser.parse(arguments);
        String resultCurrent = result.getCurrent();
        List<String> waitingFlagArguments = this.handleFlagArgument(resultCurrent, result, sender);
        if (waitingFlagArguments != null) {
            return this.map(waitingFlagArguments);
        }
        List<String> waitingArguments = this.handleNamedArgument(resultCurrent, result, sender);
        if (waitingArguments != null) {
            return this.map(waitingArguments);
        }
        if (current.startsWith("--")) {
            return this.map(this.longFlags(resultCurrent, result.getFlags()));
        }
        if (current.startsWith("-")) {
            return this.map(this.flags(resultCurrent, result.getFlags()));
        }
        return this.map(this.namedArguments(resultCurrent, result.getNamedArguments()));
    }

    @NotNull
    private List<ST> map(@NotNull List<String> suggestions) {
        return this.mapper.map(suggestions, this.getType());
    }

    @NotNull
    private List<String> longFlags(@NotNull String current, @NotNull Map<Flag, String> parsed) {
        return this.flagInternalArguments.keySet().stream().filter(it -> !parsed.containsKey(it)).map(Flag::getLongFlag).filter(Objects::nonNull).map((? super T it) -> "--" + it).filter(it -> it.startsWith(current)).collect(Collectors.toList());
    }

    @NotNull
    private List<String> flags(@NotNull String current, @NotNull Map<Flag, String> parsed) {
        return this.flagInternalArguments.keySet().stream().filter(it -> !parsed.containsKey(it)).map(Flag::getFlag).filter(Objects::nonNull).map((? super T it) -> "-" + it).filter(it -> it.startsWith(current)).collect(Collectors.toList());
    }

    @NotNull
    private List<String> namedArguments(@NotNull String current, @NotNull Map<Argument, String> parsed) {
        return this.argumentInternalArguments.keySet().stream().filter(it -> !parsed.containsKey(it)).flatMap(it -> Stream.of(it.getName(), it.getLongName())).filter(Objects::nonNull).filter(it -> it.startsWith(current)).map((? super T it) -> it + ":").collect(Collectors.toList());
    }

    @Nullable
    private List<String> handleNamedArgument(@NotNull String current, @NotNull ArgumentParser.Result result, @NotNull S sender) {
        Argument waiting = result.getArgumentWaiting();
        if (waiting == null) {
            return null;
        }
        InternalArgument internalArgument = this.argumentInternalArguments.get(waiting);
        if (internalArgument == null) {
            return null;
        }
        String raw = (waiting.isLongNameArgument() ? waiting.getLongName() : waiting.getName()) + ":";
        List<String> suggestions = internalArgument.suggestions(sender, current, Collections.singletonList(current), Collections.emptyMap()).stream().map((? super T it) -> raw + it).collect(Collectors.toList());
        if (suggestions.isEmpty()) {
            return Collections.singletonList(raw);
        }
        return suggestions;
    }

    @Nullable
    private List<String> handleFlagArgument(@NotNull String current, @NotNull ArgumentParser.Result result, @NotNull S sender) {
        Pair<Flag, ArgumentParser.Result.FlagType> waitingFlag = result.getFlagWaiting();
        if (waitingFlag == null) {
            return null;
        }
        Flag flag = waitingFlag.first();
        ArgumentParser.Result.FlagType type = waitingFlag.second();
        if (flag == null || type == null) {
            return null;
        }
        InternalArgument internalArgument = this.flagInternalArguments.get(flag);
        if (internalArgument == null) {
            return null;
        }
        return this.mapper.mapBackwards(internalArgument.suggestions(sender, current, Collections.singletonList(current), Collections.emptyMap())).stream().map((? super T it) -> {
            if (!type.hasEquals()) {
                return it;
            }
            String prefix = type.isLong() ? "--" + flag.getLongFlag() : "-" + flag.getFlag();
            return prefix + "=" + it;
        }).collect(Collectors.toList());
    }
}

