/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.tasks.processors;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import libs.com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import libs.com.ryderbelserion.fusion.paper.scheduler.Scheduler;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class PoolProcessor {
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private ThreadPoolExecutor executor = null;
    private final int maxQueueSize = 10000;
    private ScheduledTask taskId;

    public PoolProcessor() {
        this.start();
    }

    public void add(Runnable process) {
        this.executor.submit(process);
    }

    public void start() {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(1, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000));
        }
        this.executor.allowCoreThreadTimeOut(true);
        this.resizeChecker();
    }

    public void stop() {
        this.taskId.cancel();
        this.executor.shutdown();
        this.executor = null;
    }

    private void resizeChecker() {
        this.taskId = new FoliaScheduler(this.plugin, Scheduler.async_scheduler, TimeUnit.SECONDS){

            @Override
            public void run() {
                if (PoolProcessor.this.executor.getQueue().size() / PoolProcessor.this.executor.getCorePoolSize() > 2000 && PoolProcessor.this.executor.getMaximumPoolSize() > PoolProcessor.this.executor.getCorePoolSize() + 1) {
                    PoolProcessor.this.executor.setCorePoolSize(PoolProcessor.this.executor.getCorePoolSize() + 1);
                }
            }
        }.runAtFixedRate(20L, 100L);
    }
}

