/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.tasks.processors;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import com.badbones69.crazyenchantments.paper.tasks.processors.PoolProcessor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArmorProcessor
extends PoolProcessor {
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final Starter starter = this.plugin.getStarter();
    private final Methods methods = this.starter.getMethods();
    private final PluginSupport pluginSupport = this.starter.getPluginSupport();
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();

    public void add(UUID id) {
        this.add(() -> this.process(id));
    }

    public void process(UUID playerId) {
        Player player = this.plugin.getServer().getPlayer(playerId);
        if (player == null) {
            return;
        }
        for (ItemStack armor : Objects.requireNonNull(player.getEquipment()).getArmorContents()) {
            Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(armor);
            if (enchantments.isEmpty()) continue;
            int heal = 1;
            double maxHealth = Objects.requireNonNull(player.getAttribute(Attribute.MAX_HEALTH)).getValue();
            if (maxHealth > player.getHealth() && player.getHealth() > 0.0) {
                this.checkNursery(armor, player, enchantments, heal, maxHealth);
            }
            if (player.getFoodLevel() < 20) {
                this.checkImplants(armor, player, enchantments);
            }
            this.checkCommander(armor, player, enchantments);
            if (PluginSupport.SupportedPlugins.FACTIONS_UUID.isPluginLoaded()) {
                int radius = 4 + enchantments.get(CEnchantments.ANGEL.getEnchantment());
                this.checkAngel(armor, player, enchantments, radius);
            }
            this.useHellForge(player, armor, enchantments);
        }
        PlayerInventory inv = player.getInventory();
        this.useHellForge(player, inv.getItemInMainHand(), this.enchantmentBookSettings.getEnchantments(inv.getItemInMainHand()));
        this.useHellForge(player, inv.getItemInOffHand(), this.enchantmentBookSettings.getEnchantments(inv.getItemInOffHand()));
    }

    private void checkCommander(final ItemStack armor, final Player player, Map<CEnchantment, Integer> enchantments) {
        if (!EnchantUtils.isMoveEventActive(CEnchantments.COMMANDER, player, enchantments)) {
            return;
        }
        final int radius = 4 + enchantments.get(CEnchantments.COMMANDER.getEnchantment());
        new FoliaScheduler(this.plugin, null, (Entity)player){

            @Override
            public void run() {
                if (EnchantUtils.normalEnchantEvent(CEnchantments.COMMANDER, (Entity)player, armor)) {
                    final PotionEffect fastDigging = new PotionEffect(PotionEffectType.HASTE, 60, 1);
                    for (final Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
                        new FoliaScheduler(ArmorProcessor.this.plugin, null, entity){

                            @Override
                            public void run() {
                                Player otherPlayer;
                                if (entity instanceof Player && ArmorProcessor.this.pluginSupport.isFriendly((Entity)player, (Entity)(otherPlayer = (Player)entity))) {
                                    otherPlayer.addPotionEffect(fastDigging);
                                }
                            }
                        }.runNextTick();
                    }
                }
            }
        }.runNextTick();
    }

    private void checkAngel(final ItemStack armor, final Player player, Map<CEnchantment, Integer> enchantments, final int radius) {
        if (!EnchantUtils.isMoveEventActive(CEnchantments.ANGEL, player, enchantments)) {
            return;
        }
        new FoliaScheduler(this.plugin, null, (Entity)player){

            @Override
            public void run() {
                if (!EnchantUtils.normalEnchantEvent(CEnchantments.ANGEL, (Entity)player, armor)) {
                    return;
                }
                final ArrayList players = new ArrayList();
                for (final Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
                    new FoliaScheduler(ArmorProcessor.this.plugin, null, entity){

                        @Override
                        public void run() {
                            Player otherPlayer;
                            if (entity instanceof Player && ArmorProcessor.this.pluginSupport.isFriendly((Entity)player, (Entity)(otherPlayer = (Player)entity))) {
                                players.add(otherPlayer);
                            }
                        }
                    }.runNextTick();
                }
                if (players.isEmpty()) {
                    return;
                }
                final PotionEffect regeneration = new PotionEffect(PotionEffectType.REGENERATION, 60, 0);
                for (final Player target : players) {
                    new FoliaScheduler(this, ArmorProcessor.this.plugin, null, (Entity)target){

                        @Override
                        public void run() {
                            target.addPotionEffect(regeneration);
                        }
                    }.runNextTick();
                }
            }
        }.runNextTick();
    }

    private void checkImplants(final ItemStack armor, final Player player, final Map<CEnchantment, Integer> enchantments) {
        if (!EnchantUtils.isMoveEventActive(CEnchantments.IMPLANTS, player, enchantments)) {
            return;
        }
        new FoliaScheduler(this, this.plugin, null, (Entity)player){

            @Override
            public void run() {
                if (EnchantUtils.normalEnchantEvent(CEnchantments.IMPLANTS, (Entity)player, armor)) {
                    player.setFoodLevel(Math.min(20, player.getFoodLevel() + (Integer)enchantments.get(CEnchantments.IMPLANTS.getEnchantment())));
                }
            }
        }.runNextTick();
    }

    private void checkNursery(final ItemStack armor, final Player player, Map<CEnchantment, Integer> enchantments, final int heal, final double maxHealth) {
        if (!EnchantUtils.isMoveEventActive(CEnchantments.NURSERY, player, enchantments)) {
            return;
        }
        new FoliaScheduler(this, this.plugin, null, (Entity)player){

            @Override
            public void run() {
                if (EnchantUtils.normalEnchantEvent(CEnchantments.NURSERY, (Entity)player, armor)) {
                    if (player.getHealth() + (double)heal <= maxHealth) {
                        player.setHealth(player.getHealth() + (double)heal);
                    }
                    if (player.getHealth() + (double)heal >= maxHealth) {
                        player.setHealth(maxHealth);
                    }
                }
            }
        }.runNextTick();
    }

    private void useHellForge(final Player player, final ItemStack item, final Map<CEnchantment, Integer> enchantments) {
        if (!EnchantUtils.isMoveEventActive(CEnchantments.HELLFORGED, player, enchantments)) {
            return;
        }
        new FoliaScheduler(this.plugin, null, (Entity)player){

            @Override
            public void run() {
                if (!EnchantUtils.normalEnchantEvent(CEnchantments.HELLFORGED, (Entity)player, item)) {
                    return;
                }
                int armorDurability = ArmorProcessor.this.methods.getDurability(item);
                if (armorDurability <= 0) {
                    return;
                }
                int finalArmorDurability = armorDurability;
                ArmorProcessor.this.methods.setDurability(item, finalArmorDurability -= ((Integer)enchantments.get(CEnchantments.HELLFORGED.getEnchantment())).intValue());
            }
        }.runNextTick();
    }
}

