/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.support;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import libs.com.ryderbelserion.fusion.paper.scheduler.Scheduler;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SkullCreator {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final Server server = this.plugin.getServer();

    @Deprecated
    public ItemStack itemFromName(String name) {
        ItemStack item = this.getPlayerSkullItem();
        return this.itemWithName(item, name);
    }

    @Deprecated
    public ItemStack itemWithName(ItemStack item, String name) {
        this.notNull(item, "item");
        this.notNull(name, "name");
        return this.server.getUnsafe().modifyItemStack(item, "{SkullOwner:\"" + name + "\"}");
    }

    public ItemStack itemFromUuid(UUID id) {
        ItemStack item = this.getPlayerSkullItem();
        return this.itemWithUuid(item, id);
    }

    public ItemStack itemWithUuid(ItemStack item, UUID id) {
        this.notNull(item, "item");
        this.notNull(id, "id");
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        assert (meta != null);
        meta.setOwningPlayer(this.server.getOfflinePlayer(id));
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public ItemStack itemFromUrl(String url) {
        ItemStack item = this.getPlayerSkullItem();
        return this.itemWithUrl(item, url);
    }

    public ItemStack itemWithUrl(ItemStack item, String url) {
        this.notNull(item, "item");
        this.notNull(url, "url");
        return this.itemWithBase64(item, this.urlToBase64(url));
    }

    public ItemStack itemFromBase64(String base64) {
        ItemStack item = this.getPlayerSkullItem();
        return this.itemWithBase64(item, base64);
    }

    public ItemStack itemWithBase64(ItemStack item, String base64) {
        this.notNull(item, "item");
        this.notNull(base64, "base64");
        UUID hashAsId = new UUID(base64.hashCode(), base64.hashCode());
        return this.server.getUnsafe().modifyItemStack(item, "{SkullOwner:{Id:\"" + String.valueOf(hashAsId) + "\",Properties:{textures:[{Value:\"" + base64 + "\"}]}}}");
    }

    @Deprecated
    public void blockWithName(Block block, String name) {
        this.notNull(block, "block");
        this.notNull(name, "name");
        this.setBlockType(block);
        ((Skull)block.getState()).setOwningPlayer(Bukkit.getOfflinePlayer((String)name));
    }

    public void blockWithUuid(Block block, UUID id) {
        this.notNull(block, "block");
        this.notNull(id, "id");
        this.setBlockType(block);
        ((Skull)block.getState()).setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
    }

    public void blockWithUrl(Block block, String url) {
        this.notNull(block, "block");
        this.notNull(url, "url");
        this.blockWithBase64(block, this.urlToBase64(url));
    }

    public void blockWithBase64(Block block, String base64) {
        this.notNull(block, "block");
        this.notNull(base64, "base64");
        UUID hashAsId = new UUID(base64.hashCode(), base64.hashCode());
        final String args = String.format("%d %d %d %s", block.getX(), block.getY(), block.getZ(), "{Owner:{Id:\"" + String.valueOf(hashAsId) + "\",Properties:{textures:[{Value:\"" + base64 + "\"}]}}}");
        new FoliaScheduler(this.plugin, Scheduler.global_scheduler){

            @Override
            public void run() {
                SkullCreator.this.server.dispatchCommand((CommandSender)SkullCreator.this.server.getConsoleSender(), "data merge block " + args);
            }
        }.execute();
    }

    private boolean newerApi() {
        try {
            Material.valueOf((String)"PLAYER_HEAD");
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private ItemStack getPlayerSkullItem() {
        return new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
    }

    private void setBlockType(Block block) {
        try {
            block.setType(Material.valueOf((String)"PLAYER_HEAD"), false);
        }
        catch (IllegalArgumentException e) {
            block.setType(Material.valueOf((String)"SKULL"), false);
        }
    }

    private void notNull(Object object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " should not be null!");
        }
    }

    private String urlToBase64(String url) {
        URI actualUrl;
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String toEncode = "{\"textures\":{\"SKIN\":{\"url\":\"" + String.valueOf(actualUrl) + "\"}}}";
        return Base64.getEncoder().encodeToString(toEncode.getBytes());
    }
}

