/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.listeners;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.MenuManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.ShopMenu;
import com.badbones69.crazyenchantments.paper.api.economy.CurrencyAPI;
import com.badbones69.crazyenchantments.paper.api.enums.Dust;
import com.badbones69.crazyenchantments.paper.api.enums.Scrolls;
import com.badbones69.crazyenchantments.paper.api.enums.ShopOption;
import com.badbones69.crazyenchantments.paper.api.events.BuyBookEvent;
import com.badbones69.crazyenchantments.paper.api.managers.ShopManager;
import com.badbones69.crazyenchantments.paper.api.objects.CEBook;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import com.badbones69.crazyenchantments.paper.api.objects.LostBook;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.controllers.settings.ProtectionCrystalSettings;
import com.badbones69.crazyenchantments.paper.listeners.ScramblerListener;
import com.badbones69.crazyenchantments.paper.listeners.SlotCrystalListener;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ShopListener
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final CrazyManager crazyManager = this.starter.getCrazyManager();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final ProtectionCrystalSettings protectionCrystalSettings = this.starter.getProtectionCrystalSettings();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    @NotNull
    private final ShopManager shopManager = this.starter.getShopManager();
    @NotNull
    private final ScramblerListener scramblerListener = this.starter.getScramblerListener();
    @NotNull
    private final SlotCrystalListener slotCrystalListener = this.starter.getSlotCrystalListener();
    @NotNull
    private final CurrencyAPI currencyAPI = this.starter.getCurrencyAPI();

    @EventHandler(ignoreCancelled=true)
    public void onInvClick(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder(false);
        if (!(inventoryHolder instanceof ShopMenu)) {
            return;
        }
        ShopMenu holder = (ShopMenu)inventoryHolder;
        if (item == null) {
            return;
        }
        Player player = holder.getPlayer();
        event.setCancelled(true);
        if (event.getClickedInventory() != player.getOpenInventory().getTopInventory()) {
            return;
        }
        for (Category category : this.enchantmentBookSettings.getCategories()) {
            if (category.isInGUI() && item.isSimilar(category.getDisplayItem().build())) {
                CEBook book;
                if (this.methods.isInventoryFull(player)) {
                    return;
                }
                if (category.getCurrency() != null && player.getGameMode() != GameMode.CREATIVE) {
                    if (this.currencyAPI.canBuy(player, category)) {
                        this.currencyAPI.takeCurrency(player, category);
                    } else {
                        String needed = String.valueOf(category.getCost() - this.currencyAPI.getCurrency(player, category.getCurrency()));
                        this.methods.switchCurrency(player, category.getCurrency(), "%Money_Needed%", "%XP%", needed);
                        return;
                    }
                }
                if ((book = this.crazyManager.getRandomEnchantmentBook(category)) != null) {
                    BuyBookEvent buyBookEvent = new BuyBookEvent(this.crazyManager.getCEPlayer(player), category.getCurrency(), category.getCost(), book);
                    this.plugin.getServer().getPluginManager().callEvent((Event)buyBookEvent);
                    player.getInventory().addItem(new ItemStack[]{book.buildBook()});
                } else {
                    player.sendMessage(ColorUtils.getPrefix("&cThe category &6" + category.getName() + " &chas no enchantments assigned to it."));
                }
                return;
            }
            LostBook lostBook = category.getLostBook();
            if (!lostBook.isInGUI() || !item.isSimilar(lostBook.getDisplayItem().build())) continue;
            if (this.methods.isInventoryFull(player)) {
                return;
            }
            if (lostBook.getCurrency() != null && player.getGameMode() != GameMode.CREATIVE) {
                if (this.currencyAPI.canBuy(player, lostBook)) {
                    this.currencyAPI.takeCurrency(player, lostBook);
                } else {
                    String needed = String.valueOf(lostBook.getCost() - this.currencyAPI.getCurrency(player, lostBook.getCurrency()));
                    this.methods.switchCurrency(player, lostBook.getCurrency(), "%Money_Needed%", "%XP%", needed);
                    return;
                }
            }
            player.getInventory().addItem(new ItemStack[]{lostBook.getLostBook(category).build()});
            return;
        }
        for (ShopOption option : ShopOption.values()) {
            if (!option.isInGUI() || !item.isSimilar(option.getItem())) continue;
            if (option.isBuyable()) {
                if (this.methods.isInventoryFull(player)) {
                    return;
                }
                if (option.getCurrency() != null && player.getGameMode() != GameMode.CREATIVE) {
                    if (this.currencyAPI.canBuy(player, option)) {
                        this.currencyAPI.takeCurrency(player, option);
                    } else {
                        String needed = String.valueOf(option.getCost() - this.currencyAPI.getCurrency(player, option.getCurrency()));
                        this.methods.switchCurrency(player, option.getCurrency(), "%Money_Needed%", "%XP%", needed);
                        return;
                    }
                }
            }
            switch (option) {
                case GKITZ: {
                    if (!this.methods.hasPermission(player, "gkitz", true)) {
                        return;
                    }
                    if (!this.crazyManager.isGkitzEnabled()) {
                        return;
                    }
                    MenuManager.openKitsMenu(player);
                    break;
                }
                case BLACKSMITH: {
                    if (!this.methods.hasPermission(player, "blacksmith", true)) {
                        return;
                    }
                    MenuManager.openBlackSmithMenu(player);
                    break;
                }
                case TINKER: {
                    if (!this.methods.hasPermission(player, "tinker", true)) {
                        return;
                    }
                    MenuManager.openTinkererMenu(player);
                    break;
                }
                case INFO: {
                    MenuManager.openInfoMenu(player);
                    break;
                }
                case PROTECTION_CRYSTAL: {
                    player.getInventory().addItem(new ItemStack[]{this.protectionCrystalSettings.getCrystal()});
                    break;
                }
                case SCRAMBLER: {
                    player.getInventory().addItem(new ItemStack[]{this.scramblerListener.getScramblers()});
                    break;
                }
                case SUCCESS_DUST: {
                    player.getInventory().addItem(new ItemStack[]{Dust.SUCCESS_DUST.getDust()});
                    break;
                }
                case DESTROY_DUST: {
                    player.getInventory().addItem(new ItemStack[]{Dust.DESTROY_DUST.getDust()});
                    break;
                }
                case BLACK_SCROLL: {
                    player.getInventory().addItem(new ItemStack[]{Scrolls.BLACK_SCROLL.getScroll()});
                    break;
                }
                case WHITE_SCROLL: {
                    player.getInventory().addItem(new ItemStack[]{Scrolls.WHITE_SCROLL.getScroll()});
                    break;
                }
                case TRANSMOG_SCROLL: {
                    player.getInventory().addItem(new ItemStack[]{Scrolls.TRANSMOG_SCROLL.getScroll()});
                    break;
                }
                case SLOT_CRYSTAL: {
                    player.getInventory().addItem(new ItemStack[]{this.slotCrystalListener.getSlotCrystal()});
                }
            }
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEnchantmentTableClick(PlayerInteractEvent event) {
        if (this.shopManager.isEnchantmentTableShop()) {
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            if (block != null && event.getAction() == Action.RIGHT_CLICK_BLOCK && block.getType() == Material.ENCHANTING_TABLE) {
                event.setCancelled(true);
                player.openInventory(new ShopMenu(player, this.shopManager.getInventorySize(), this.shopManager.getInventoryName()).build().getInventory());
            }
        }
    }
}

