/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.enchantments;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.economy.Currency;
import com.badbones69.crazyenchantments.paper.api.economy.CurrencyAPI;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.api.events.RageBreakEvent;
import com.badbones69.crazyenchantments.paper.api.objects.CEPlayer;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EntityUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EventUtils;
import com.badbones69.crazyenchantments.paper.controllers.BossBarController;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import libs.com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class SwordEnchantments
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final CrazyManager crazyManager = this.starter.getCrazyManager();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final PluginSupport pluginSupport = this.starter.getPluginSupport();
    @NotNull
    private final BossBarController bossBarController = this.plugin.getBossBarController();
    @NotNull
    private final CurrencyAPI currencyAPI = this.starter.getCurrencyAPI();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        Player player;
        Object rageBreakEvent;
        Player player2;
        Object cePlayer;
        Entity entity;
        if (EventUtils.isIgnoredEvent((Event)event) || EventUtils.isIgnoredUUID(event.getDamager().getUniqueId())) {
            return;
        }
        if (this.pluginSupport.isFriendly(event.getDamager(), event.getEntity())) {
            return;
        }
        if (this.crazyManager.isBreakRageOnDamageOn() && (entity = event.getEntity()) instanceof Player && (cePlayer = this.crazyManager.getCEPlayer(player2 = (Player)entity)) != null) {
            rageBreakEvent = new RageBreakEvent(player2, event.getDamager(), this.methods.getItemInHand(player2));
            this.plugin.getServer().getPluginManager().callEvent((Event)rageBreakEvent);
            if (!((RageBreakEvent)((Object)rageBreakEvent)).isCancelled() && ((CEPlayer)cePlayer).hasRage()) {
                ((CEPlayer)cePlayer).getRageTask().cancel();
                ((CEPlayer)cePlayer).setRageMultiplier(0.0);
                ((CEPlayer)cePlayer).setRageLevel(0);
                ((CEPlayer)cePlayer).setRage(false);
                this.rageInformPlayer(player2, Messages.RAGE_DAMAGED, 0.0f);
            }
        }
        if (!((cePlayer = event.getEntity()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity en = (LivingEntity)cePlayer;
        rageBreakEvent = event.getDamager();
        if (!(rageBreakEvent instanceof Player)) {
            return;
        }
        final Player damager = (Player)rageBreakEvent;
        final CEPlayer cePlayer2 = this.crazyManager.getCEPlayer(damager);
        ItemStack item = this.methods.getItemInHand(damager);
        if (event.getEntity().isDead()) {
            return;
        }
        Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(item);
        boolean isEntityPlayer = event.getEntity() instanceof Player;
        if (isEntityPlayer && EnchantUtils.isEventActive(CEnchantments.DISARMER, (Entity)damager, item, enchantments)) {
            ItemStack armor;
            player = (Player)event.getEntity();
            EquipmentSlot equipmentSlot = this.getSlot(this.methods.percentPick(4, 0));
            switch (equipmentSlot) {
                case HEAD: {
                    ItemStack itemStack = player.getEquipment().getHelmet();
                    break;
                }
                case CHEST: {
                    ItemStack itemStack = player.getEquipment().getChestplate();
                    break;
                }
                case LEGS: {
                    ItemStack itemStack = player.getEquipment().getLeggings();
                    break;
                }
                case FEET: {
                    ItemStack itemStack = player.getEquipment().getBoots();
                    break;
                }
                default: {
                    ItemStack itemStack = armor = null;
                }
            }
            if (armor != null) {
                switch (equipmentSlot) {
                    case HEAD: {
                        player.getEquipment().setHelmet(null);
                        break;
                    }
                    case CHEST: {
                        player.getEquipment().setChestplate(null);
                        break;
                    }
                    case LEGS: {
                        player.getEquipment().setLeggings(null);
                        break;
                    }
                    case FEET: {
                        player.getEquipment().setBoots(null);
                    }
                }
                this.methods.addItemToInventory(player, armor);
            }
        }
        if (isEntityPlayer && EnchantUtils.isEventActive(CEnchantments.DISORDER, (Entity)damager, item, enchantments)) {
            int i;
            player = (Player)event.getEntity();
            PlayerInventory inventory = player.getInventory();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (i = 0; i < 9; ++i) {
                ItemStack inventoryItem = inventory.getItem(i);
                if (inventoryItem != null) {
                    items.add(inventoryItem);
                    inventory.setItem(i, null);
                }
                slots.add(i);
            }
            Collections.shuffle(items);
            Collections.shuffle(slots);
            for (i = 0; i < items.size(); ++i) {
                inventory.setItem(((Integer)slots.get(i)).intValue(), (ItemStack)items.get(i));
            }
            if (!Messages.DISORDERED_ENEMY_HOT_BAR.getMessageNoPrefix().isEmpty()) {
                damager.sendMessage(Messages.DISORDERED_ENEMY_HOT_BAR.getMessage());
            }
        }
        if (cePlayer2 != null && EnchantUtils.isEventActive(CEnchantments.RAGE, (Entity)damager, item, enchantments)) {
            if (cePlayer2.hasRage()) {
                cePlayer2.getRageTask().cancel();
                if (cePlayer2.getRageMultiplier() <= (double)this.crazyManager.getRageMaxLevel()) {
                    cePlayer2.setRageMultiplier(cePlayer2.getRageMultiplier() + (double)enchantments.get(CEnchantments.RAGE.getEnchantment()).intValue() * this.crazyManager.getRageIncrement());
                }
                int rageUp = cePlayer2.getRageLevel() + 1;
                if (cePlayer2.getRageMultiplier().intValue() >= rageUp) {
                    this.rageInformPlayer(damager, Messages.RAGE_RAGE_UP, Map.of("%Level%", String.valueOf(rageUp)), (float)rageUp / (float)(this.crazyManager.getRageMaxLevel() + 1));
                    cePlayer2.setRageLevel(rageUp);
                }
                event.setDamage(event.getDamage() * cePlayer2.getRageMultiplier());
            } else {
                cePlayer2.setRageMultiplier(1.0);
                cePlayer2.setRage(true);
                cePlayer2.setRageLevel(1);
                this.rageInformPlayer(damager, Messages.RAGE_BUILDING, (float)cePlayer2.getRageLevel() / (float)this.crazyManager.getRageMaxLevel());
            }
            cePlayer2.setRageTask(new FoliaScheduler(this.plugin, null, (Entity)cePlayer2.getPlayer()){

                @Override
                public void run() {
                    cePlayer2.setRageMultiplier(0.0);
                    cePlayer2.setRage(false);
                    cePlayer2.setRageLevel(0);
                    SwordEnchantments.this.rageInformPlayer(damager, Messages.RAGE_COOLED_DOWN, 0.0f);
                }
            }.runDelayed(80L));
        }
        if (en instanceof Player) {
            Player player3 = (Player)en;
            if (EnchantUtils.isEventActive(CEnchantments.SKILLSWIPE, (Entity)damager, item, enchantments)) {
                int amount = 4 + enchantments.get(CEnchantments.SKILLSWIPE.getEnchantment());
                if (player3.getTotalExperience() > 0) {
                    if (this.currencyAPI.getCurrency(player3, Currency.XP_TOTAL) >= amount) {
                        this.currencyAPI.takeCurrency(player3, Currency.XP_TOTAL, amount);
                    } else {
                        player3.setTotalExperience(0);
                    }
                    this.currencyAPI.giveCurrency(damager, Currency.XP_TOTAL, amount);
                }
            }
        }
        if (damager.getHealth() > 0.0 && EnchantUtils.isEventActive(CEnchantments.LIFESTEAL, (Entity)damager, item, enchantments)) {
            int steal = enchantments.get(CEnchantments.LIFESTEAL.getEnchantment());
            double maxHealth = damager.getAttribute(Attribute.MAX_HEALTH).getValue();
            if (damager.getHealth() + (double)steal < maxHealth) {
                damager.setHealth(damager.getHealth() + (double)steal);
            }
            if (damager.getHealth() + (double)steal >= maxHealth) {
                damager.setHealth(maxHealth);
            }
        }
        if (EnchantUtils.isEventActive(CEnchantments.NUTRITION, (Entity)damager, item, enchantments)) {
            if (damager.getSaturation() + (float)(2 * enchantments.get(CEnchantments.NUTRITION.getEnchantment())) <= 20.0f) {
                damager.setSaturation(damager.getSaturation() + (float)(2 * enchantments.get(CEnchantments.NUTRITION.getEnchantment())));
            }
            if (damager.getSaturation() + (float)(2 * enchantments.get(CEnchantments.NUTRITION.getEnchantment())) >= 20.0f) {
                damager.setSaturation(20.0f);
            }
        }
        if (damager.getHealth() > 0.0 && EnchantUtils.isEventActive(CEnchantments.VAMPIRE, (Entity)damager, item, enchantments)) {
            double maxHealth = damager.getAttribute(Attribute.MAX_HEALTH).getValue();
            if (damager.getHealth() + event.getDamage() / 2.0 < maxHealth) {
                damager.setHealth(damager.getHealth() + event.getDamage() / 2.0);
            }
            if (damager.getHealth() + event.getDamage() / 2.0 >= maxHealth) {
                damager.setHealth(maxHealth);
            }
        }
        if (EnchantUtils.isEventActive(CEnchantments.BLINDNESS, (Entity)damager, item, enchantments)) {
            en.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, enchantments.get(CEnchantments.BLINDNESS.getEnchantment()) - 1));
        }
        if (EnchantUtils.isEventActive(CEnchantments.CONFUSION, (Entity)damager, item, enchantments)) {
            en.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, 5 + enchantments.get(CEnchantments.CONFUSION.getEnchantment()) * 20, 0));
        }
        if (EnchantUtils.isEventActive(CEnchantments.DOUBLEDAMAGE, (Entity)damager, item, enchantments)) {
            event.setDamage(event.getDamage() * 2.0);
        }
        if (EnchantUtils.isEventActive(CEnchantments.EXECUTE, (Entity)damager, item, enchantments)) {
            damager.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 3 + enchantments.get(CEnchantments.EXECUTE.getEnchantment()) * 20, 3));
        }
        if (EnchantUtils.isEventActive(CEnchantments.FASTTURN, (Entity)damager, item, enchantments)) {
            event.setDamage(event.getDamage() + event.getDamage() / 3.0);
        }
        if (EnchantUtils.isEventActive(CEnchantments.LIGHTWEIGHT, (Entity)damager, item, enchantments)) {
            damager.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, 100, enchantments.get(CEnchantments.LIGHTWEIGHT.getEnchantment()) - 1));
        }
        if (EnchantUtils.isEventActive(CEnchantments.OBLITERATE, (Entity)damager, item, enchantments)) {
            event.getEntity().setVelocity(damager.getLocation().getDirection().multiply(2).setY(1.25));
        }
        if (EnchantUtils.isEventActive(CEnchantments.PARALYZE, (Entity)damager, item, enchantments)) {
            for (LivingEntity entity2 : this.methods.getNearbyLivingEntities(2.0, (Entity)damager)) {
                EntityDamageEvent damageByEntityEvent = new EntityDamageEvent((Entity)entity2, EntityDamageEvent.DamageCause.MAGIC, DamageSource.builder((DamageType)DamageType.INDIRECT_MAGIC).withDirectEntity((Entity)damager).build(), 5.0);
                this.methods.entityEvent(damager, entity2, damageByEntityEvent);
            }
            en.getWorld().strikeLightningEffect(en.getLocation());
            en.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 60, 2));
            en.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, 60, 2));
        }
        if (EnchantUtils.isEventActive(CEnchantments.SLOWMO, (Entity)damager, item, enchantments)) {
            en.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 60, enchantments.get(CEnchantments.SLOWMO.getEnchantment()).intValue()));
        }
        if (EnchantUtils.isEventActive(CEnchantments.SNARE, (Entity)damager, item, enchantments)) {
            en.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 60, 0));
            en.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, 60, 0));
        }
        if (EnchantUtils.isEventActive(CEnchantments.TRAP, (Entity)damager, item, enchantments)) {
            en.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 60, 2));
        }
        if (EnchantUtils.isEventActive(CEnchantments.VIPER, (Entity)damager, item, enchantments)) {
            en.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 100, enchantments.get(CEnchantments.VIPER.getEnchantment()).intValue()));
        }
        if (EnchantUtils.isEventActive(CEnchantments.WITHER, (Entity)damager, item, enchantments)) {
            en.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 40, 2));
        }
        if (EnchantUtils.isEventActive(CEnchantments.FAMISHED, (Entity)damager, item, enchantments)) {
            en.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 200, 1));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Map<CEnchantment, Integer> enchantments;
        if (event.getEntity().getKiller() == null) {
            return;
        }
        Player damager = event.getEntity().getKiller();
        Player player = event.getEntity();
        ItemStack item = this.methods.getItemInHand(damager);
        if (EnchantUtils.isEventActive(CEnchantments.HEADLESS, (Entity)damager, item, enchantments = this.enchantmentBookSettings.getEnchantments(item))) {
            ItemStack head = new ItemBuilder().setMaterial("PLAYER_HEAD").setPlayerName(player.getName()).build();
            event.getDrops().add(head);
        }
        if (EnchantUtils.isEventActive(CEnchantments.REVENGE, (Entity)damager, item, enchantments)) {
            for (Entity entity : player.getNearbyEntities(10.0, 10.0, 10.0)) {
                if (!this.pluginSupport.isFriendly(entity, (Entity)player)) continue;
                Player ally = (Player)entity;
                ally.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 1));
                ally.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 100, 0));
                ally.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, 100, 1));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity().getKiller() != null) {
            double multiplier;
            Material headMat;
            Map<CEnchantment, Integer> enchantments;
            ItemStack item;
            Player damager = event.getEntity().getKiller();
            if (EnchantUtils.isEventActive(CEnchantments.INQUISITIVE, (Entity)damager, item = this.methods.getItemInHand(damager), enchantments = this.enchantmentBookSettings.getEnchantments(item))) {
                event.setDroppedExp(event.getDroppedExp() * (enchantments.get(CEnchantments.INQUISITIVE.getEnchantment()) + 1));
            }
            if ((headMat = EntityUtils.getHeadMaterial((Entity)event.getEntity())) != null && !EventUtils.containsDrop(event, headMat) && (multiplier = this.crazyManager.getDecapitationHeadMap().getOrDefault(headMat, 0.0).doubleValue()) != 0.0 && EnchantUtils.isEventActive(CEnchantments.HEADLESS, (Entity)damager, item, enchantments, multiplier)) {
                ItemStack head = new ItemBuilder().setMaterial(headMat).build();
                event.getDrops().add(head);
            }
            if (event.getEntity() instanceof Player && EnchantUtils.isEventActive(CEnchantments.CHARGE, (Entity)damager, item, enchantments)) {
                int radius = 4 + enchantments.get(CEnchantments.CHARGE.getEnchantment());
                damager.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 200, 1));
                damager.getNearbyEntities((double)radius, (double)radius, (double)radius).stream().filter(entity -> this.pluginSupport.isFriendly((Entity)entity, (Entity)damager)).forEach(entity -> ((Player)entity).addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 200, 1)));
            }
        }
    }

    private EquipmentSlot getSlot(int slot) {
        return switch (slot) {
            case 1 -> EquipmentSlot.CHEST;
            case 2 -> EquipmentSlot.LEGS;
            case 3 -> EquipmentSlot.FEET;
            default -> EquipmentSlot.HEAD;
        };
    }

    private void rageInformPlayer(Player player, Messages message, Map<String, String> placeholders, float progress) {
        if (message.getMessageNoPrefix().isBlank()) {
            return;
        }
        if (this.crazyManager.useRageBossBar()) {
            this.bossBarController.updateBossBar(player, message.getMessageNoPrefix(placeholders), progress);
        } else {
            player.sendMessage(message.getMessage(placeholders));
        }
    }

    private void rageInformPlayer(Player player, Messages message, float progress) {
        if (message.getMessageNoPrefix().isBlank()) {
            return;
        }
        if (this.crazyManager.useRageBossBar()) {
            this.bossBarController.updateBossBar(player, message.getMessageNoPrefix(), progress);
        } else {
            player.sendMessage(message.getMessage());
        }
    }
}

