/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.enchantments;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.managers.BowEnchantmentManager;
import com.badbones69.crazyenchantments.paper.api.objects.BowEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.EnchantedArrow;
import com.badbones69.crazyenchantments.paper.api.utils.BowUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EventUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import java.util.Map;
import libs.com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class BowEnchantments
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    @NotNull
    private final PluginSupport pluginSupport = this.starter.getPluginSupport();
    @NotNull
    private final BowEnchantmentManager bowEnchantmentManager = this.starter.getBowEnchantmentManager();
    @NotNull
    private final BowUtils bowUtils = this.starter.getBowUtils();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBowShoot(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (EventUtils.isIgnoredEvent((Event)event) || EventUtils.isIgnoredUUID(event.getEntity().getUniqueId())) {
            return;
        }
        Entity entity = event.getProjectile();
        if (!(entity instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)entity;
        ItemStack bow = event.getBow();
        if (!this.bowUtils.allowsCombat((Entity)player)) {
            return;
        }
        Map<CEnchantment, Integer> enchants = this.enchantmentBookSettings.getEnchantments(bow);
        if (enchants.isEmpty()) {
            return;
        }
        this.bowUtils.addArrow(arrow, bow, enchants);
        if (EnchantUtils.isEventActive(CEnchantments.MULTIARROW, (Entity)player, bow, enchants)) {
            int power = enchants.get(CEnchantments.MULTIARROW.getEnchantment());
            for (int i = 1; i <= power; ++i) {
                this.bowUtils.spawnArrows((LivingEntity)player, (Entity)arrow, bow);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLand(ProjectileHitEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        Arrow entityArrow = (Arrow)projectile;
        if (!this.bowUtils.allowsCombat((Entity)event.getEntity())) {
            return;
        }
        final EnchantedArrow enchantedArrow = this.bowUtils.getEnchantedArrow(entityArrow);
        if (enchantedArrow == null) {
            return;
        }
        this.bowUtils.spawnWebs(event.getHitEntity(), enchantedArrow);
        if (EnchantUtils.isEventActive(CEnchantments.BOOM, (Entity)shooter, enchantedArrow.bow(), enchantedArrow.enchantments())) {
            this.methods.explode(enchantedArrow.getShooter(), (Entity)enchantedArrow.arrow());
            enchantedArrow.arrow().remove();
        }
        if (EnchantUtils.isEventActive(CEnchantments.LIGHTNING, (Entity)shooter, enchantedArrow.bow(), enchantedArrow.enchantments())) {
            Location location = enchantedArrow.arrow().getLocation();
            LightningStrike lightning = location.getWorld().strikeLightningEffect(location);
            int lightningSoundRange = FileManager.Files.CONFIG.getFile().getInt("Settings.EnchantmentOptions.Lightning-Sound-Range", 160);
            try {
                location.getWorld().playSound(location, Sound.ENTITY_LIGHTNING_BOLT_IMPACT, (float)lightningSoundRange / 16.0f, 1.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (LivingEntity entity : this.methods.getNearbyLivingEntities(2.0, (Entity)enchantedArrow.arrow())) {
                EntityDamageEvent damageByEntityEvent = new EntityDamageEvent((Entity)entity, EntityDamageEvent.DamageCause.LIGHTNING, DamageSource.builder((DamageType)DamageType.LIGHTNING_BOLT).withCausingEntity((Entity)shooter).withDirectEntity((Entity)lightning).build(), 5.0);
                EventUtils.addIgnoredEvent((Event)damageByEntityEvent);
                EventUtils.addIgnoredUUID(shooter.getUniqueId());
                shooter.getServer().getPluginManager().callEvent((Event)damageByEntityEvent);
                if (!(damageByEntityEvent.isCancelled() || this.pluginSupport.isFriendly(enchantedArrow.getShooter(), (Entity)entity) || enchantedArrow.getShooter().getUniqueId().equals(entity.getUniqueId()))) {
                    entity.damage(5.0);
                }
                EventUtils.removeIgnoredEvent((Event)damageByEntityEvent);
                EventUtils.removeIgnoredUUID(shooter.getUniqueId());
            }
        }
        new FoliaScheduler(this.plugin, null, (Entity)entityArrow){

            @Override
            public void run() {
                BowEnchantments.this.bowUtils.removeArrow(enchantedArrow);
            }
        }.runDelayed(5L);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onArrowDamage(EntityDamageByEntityEvent event) {
        if (EventUtils.isIgnoredEvent((Event)event)) {
            return;
        }
        Entity entity = event.getDamager();
        if (!(entity instanceof Arrow)) {
            return;
        }
        Arrow entityArrow = (Arrow)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity3 = (LivingEntity)entity2;
        EnchantedArrow enchantedArrow = this.bowUtils.getEnchantedArrow(entityArrow);
        if (enchantedArrow == null) {
            return;
        }
        if (!this.pluginSupport.allowCombat(enchantedArrow.arrow().getLocation())) {
            return;
        }
        if (EnchantUtils.isEventActive(CEnchantments.DOCTOR, enchantedArrow.getShooter(), enchantedArrow.bow(), enchantedArrow.enchantments()) && this.pluginSupport.isFriendly(enchantedArrow.getShooter(), event.getEntity())) {
            int heal = 1 + enchantedArrow.getLevel(CEnchantments.DOCTOR);
            double maxHealth = entity3.getAttribute(Attribute.MAX_HEALTH).getValue();
            if (entity3.getHealth() < maxHealth) {
                if (entity3.getHealth() + (double)heal < maxHealth) {
                    entity3.setHealth(entity3.getHealth() + (double)heal);
                }
                if (entity3.getHealth() + (double)heal >= maxHealth) {
                    entity3.setHealth(maxHealth);
                }
            }
        }
        if (this.pluginSupport.isFriendly(enchantedArrow.getShooter(), (Entity)entity3)) {
            return;
        }
        this.bowUtils.spawnWebs(event.getEntity(), enchantedArrow);
        if (EnchantUtils.isEventActive(CEnchantments.PULL, enchantedArrow.getShooter(), enchantedArrow.bow(), enchantedArrow.enchantments())) {
            Vector v = enchantedArrow.getShooter().getLocation().toVector().subtract(entity3.getLocation().toVector()).normalize().multiply(3);
            entity3.setVelocity(v);
        }
        for (BowEnchantment bowEnchantment : this.bowEnchantmentManager.getBowEnchantments()) {
            CEnchantments enchantment = bowEnchantment.getEnchantment();
            if (!EnchantUtils.isEventActive(enchantment, enchantedArrow.getShooter(), enchantedArrow.bow(), enchantedArrow.enchantments())) continue;
            if (bowEnchantment.isPotionEnchantment()) {
                bowEnchantment.getPotionEffects().forEach(effect -> entity3.addPotionEffect(new PotionEffect(effect.potionEffect(), effect.duration(), (bowEnchantment.isLevelAddedToAmplifier() ? enchantedArrow.getLevel(enchantment) : 0) + effect.amplifier())));
                continue;
            }
            event.setDamage(event.getDamage() * ((double)(bowEnchantment.isLevelAddedToAmplifier() ? enchantedArrow.getLevel(enchantment) : 0) + bowEnchantment.getDamageAmplifier()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onWebBreak(BlockBreakEvent event) {
        if (!EventUtils.isIgnoredEvent((Event)event) && this.bowUtils.getWebBlocks().contains(event.getBlock())) {
            event.setCancelled(true);
        }
    }
}

