/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.commands;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.commands.BlackSmithCommand;
import com.badbones69.crazyenchantments.paper.commands.relations.ArgumentRelations;
import dev.triumphteam.cmd.bukkit.BukkitCommandManager;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import java.util.ArrayList;
import java.util.List;
import libs.com.ryderbelserion.fusion.paper.builders.PlayerBuilder;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CommandManager {
    private static final CrazyEnchantments plugin = (CrazyEnchantments)CrazyEnchantments.getPlugin(CrazyEnchantments.class);
    private static final Server server = plugin.getServer();
    private static final BukkitCommandManager<CommandSender> commandManager = BukkitCommandManager.create((Plugin)plugin);

    public static void load() {
        new ArgumentRelations().build();
        commandManager.registerSuggestion(SuggestionKey.of("players"), context -> server.getOnlinePlayers().stream().map(Player::getName).toList());
        commandManager.registerSuggestion(SuggestionKey.of("numbers"), context -> {
            ArrayList<String> numbers = new ArrayList<String>();
            for (int i = 1; i <= 100; ++i) {
                numbers.add(String.valueOf(i));
            }
            return numbers;
        });
        commandManager.registerSuggestion(SuggestionKey.of("doubles"), context -> {
            ArrayList<String> numbers = new ArrayList<String>();
            for (int count = 0; count <= 1000; ++count) {
                double x = (double)count / 10.0;
                numbers.add(String.valueOf(x));
            }
            return numbers;
        });
        commandManager.registerArgument(PlayerBuilder.class, (sender, context) -> new PlayerBuilder(plugin, context));
        List.of(new BlackSmithCommand()).forEach(commandManager::registerCommand);
    }

    @NotNull
    public static BukkitCommandManager<CommandSender> getCommandManager() {
        return commandManager;
    }
}

