/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.utils;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.EnchantedArrow;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import libs.com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class BowUtils {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private final List<Block> webBlocks = new ArrayList<Block>();
    private final List<EnchantedArrow> enchantedArrows = new ArrayList<EnchantedArrow>();

    public void addArrow(Arrow arrow, ItemStack bow, Map<CEnchantment, Integer> enchantments) {
        if (arrow == null) {
            return;
        }
        EnchantedArrow enchantedArrow = new EnchantedArrow(arrow, bow, enchantments);
        this.enchantedArrows.add(enchantedArrow);
    }

    public void removeArrow(EnchantedArrow enchantedArrow) {
        if (!this.enchantedArrows.contains(enchantedArrow) || enchantedArrow == null) {
            return;
        }
        this.enchantedArrows.remove(enchantedArrow);
    }

    public boolean isBowEnchantActive(CEnchantments customEnchant, EnchantedArrow enchantedArrow) {
        return customEnchant.isActivated() && enchantedArrow.hasEnchantment(customEnchant) && customEnchant.chanceSuccessful(enchantedArrow.getLevel(customEnchant));
    }

    public boolean allowsCombat(Entity entity) {
        return this.starter.getPluginSupport().allowCombat(entity.getLocation());
    }

    public EnchantedArrow getEnchantedArrow(Arrow arrow) {
        return this.enchantedArrows.stream().filter(enchArrow -> enchArrow != null && enchArrow.arrow() != null && enchArrow.arrow().equals((Object)arrow)).findFirst().orElse(null);
    }

    public void spawnArrows(LivingEntity shooter, Entity projectile, ItemStack bow) {
        Arrow spawnedArrow = (Arrow)shooter.getWorld().spawn(projectile.getLocation(), Arrow.class);
        EnchantedArrow enchantedMultiArrow = new EnchantedArrow(spawnedArrow, bow, this.enchantmentBookSettings.getEnchantments(bow));
        this.enchantedArrows.add(enchantedMultiArrow);
        spawnedArrow.setShooter((ProjectileSource)shooter);
        Vector vector = new Vector(this.randomSpread(), 0.0f, this.randomSpread());
        spawnedArrow.setVelocity(projectile.getVelocity().add(vector));
        if (((Arrow)projectile).isCritical()) {
            spawnedArrow.setCritical(true);
        }
        if (projectile.getFireTicks() > 0) {
            spawnedArrow.setFireTicks(projectile.getFireTicks());
        }
        spawnedArrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
    }

    private float randomSpread() {
        float spread = 0.2f;
        return -spread + (float)(Math.random() * (double)(spread * 2.0f));
    }

    public List<Block> getWebBlocks() {
        return this.webBlocks;
    }

    public void spawnWebs(Entity hitEntity, EnchantedArrow enchantedArrow) {
        if (enchantedArrow == null) {
            return;
        }
        Arrow arrow = enchantedArrow.getArrow();
        if (!EnchantUtils.isEventActive(CEnchantments.STICKY_SHOT, enchantedArrow.getShooter(), enchantedArrow.arrow().getWeapon(), enchantedArrow.getEnchantments())) {
            return;
        }
        if (hitEntity == null) {
            final Location entityLocation = arrow.getLocation();
            if (entityLocation.getBlock().getType() != Material.AIR) {
                return;
            }
            entityLocation.getBlock().setType(Material.COBWEB);
            this.webBlocks.add(entityLocation.getBlock());
            new FoliaScheduler(this.plugin, entityLocation){

                @Override
                public void run() {
                    entityLocation.getBlock().setType(Material.AIR);
                    BowUtils.this.webBlocks.remove(entityLocation.getBlock());
                }
            }.runDelayed(100L);
        } else {
            this.setWebBlocks(hitEntity);
        }
        arrow.remove();
    }

    private void setWebBlocks(final Entity hitEntity) {
        Location location = hitEntity.getLocation();
        new FoliaScheduler(this.plugin, location){

            @Override
            public void run() {
                for (final Block block : BowUtils.this.getCube(hitEntity.getLocation())) {
                    block.setType(Material.COBWEB);
                    BowUtils.this.webBlocks.add(block);
                    new FoliaScheduler(BowUtils.this.plugin, block.getLocation()){

                        @Override
                        public void run() {
                            if (block.getType() == Material.COBWEB) {
                                block.setType(Material.AIR);
                                BowUtils.this.webBlocks.remove(block);
                            }
                        }
                    }.runDelayed(100L);
                }
            }
        }.execute();
    }

    private List<Block> getCube(Location start) {
        ArrayList<Block> newBlocks = new ArrayList<Block>();
        for (double x = start.getX() - 1.0; x <= start.getX() + 1.0; x += 1.0) {
            for (double z = start.getZ() - 1.0; z <= start.getZ() + 1.0; z += 1.0) {
                Location loc = new Location(start.getWorld(), x, start.getY(), z);
                if (loc.getBlock().getType() != Material.AIR) continue;
                newBlocks.add(loc.getBlock());
            }
        }
        return newBlocks;
    }
}

