/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.enums;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DustData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public enum Dust {
    SUCCESS_DUST("Success-Dust", "SuccessDust", Arrays.asList("s", "success")),
    DESTROY_DUST("Destroy-Dust", "DestroyDust", Arrays.asList("d", "destroy")),
    MYSTERY_DUST("Mystery-Dust", "MysteryDust", Arrays.asList("m", "mystery")),
    FAILED_DUST("Failed-Dust", "FailedDust", Arrays.asList("f", "failed"));

    private static final HashMap<Dust, ItemBuilder> itemBuilderDust;
    private final String name;
    private final String configName;
    private final List<String> knownNames;
    private final int max;
    private final int min;
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Methods methods = this.plugin.getStarter().getMethods();

    private Dust(String name, String configName, List<String> knowNames) {
        this.name = name;
        this.knownNames = knowNames;
        this.configName = configName;
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        this.max = config.getInt("Settings.Dust." + configName + ".PercentRange.Max", 100);
        this.min = config.getInt("Settings.Dust." + configName + ".PercentRange.Min", this.max);
    }

    public static void loadDust() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        itemBuilderDust.clear();
        for (Dust dust : Dust.values()) {
            String path = "Settings.Dust." + dust.getConfigName() + ".";
            itemBuilderDust.put(dust, new ItemBuilder().setName(config.getString(path + "Name", "Error getting name.")).setLore(config.getStringList(path + "Lore")).setItemModel(config.getString(path + "Model.Namespace", ""), config.getString(path + "Model.Key", "")).setMaterial(config.getString(path + "Item", "GLOWSTONE_DUST")));
        }
    }

    public static Dust getFromName(String nameString) {
        for (Dust dust : Dust.values()) {
            if (!dust.getKnownNames().contains(nameString.toLowerCase()) && !dust.getConfigName().contains(nameString)) continue;
            return dust;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getKnownNames() {
        return this.knownNames;
    }

    public String getConfigName() {
        return this.configName;
    }

    public ItemStack getDust() {
        return this.getDust(1);
    }

    public ItemStack getDust(int amount) {
        return this.getDust(this.methods.percentPick(this.max, this.min), amount);
    }

    public ItemStack getDust(int percent, int amount) {
        ItemStack item = itemBuilderDust.get((Object)this).addLorePlaceholder("%Percent%", String.valueOf(percent)).setAmount(amount).build();
        if (Objects.equals(this.getName(), FAILED_DUST.getName())) {
            return item;
        }
        item.editPersistentDataContainer(container -> container.set(DataKeys.dust.getNamespacedKey(), PersistentDataType.STRING, (Object)Methods.getGson().toJson(new DustData(this.getConfigName(), this.min, this.max, percent))));
        return item;
    }

    static {
        itemBuilderDust = new HashMap();
    }
}

