/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.economy;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.economy.Currency;
import com.badbones69.crazyenchantments.paper.api.economy.vault.VaultSupport;
import com.badbones69.crazyenchantments.paper.api.enums.ShopOption;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import com.badbones69.crazyenchantments.paper.api.objects.LostBook;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CurrencyAPI {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();

    public int getCurrency(Player player, Currency currency) {
        try {
            return switch (currency) {
                default -> throw new MatchException(null, null);
                case Currency.VAULT -> (int)this.starter.getVaultSupport().getVault().getBalance((OfflinePlayer)player);
                case Currency.XP_LEVEL -> player.getLevel();
                case Currency.XP_TOTAL -> this.getTotalExperience(player);
            };
        }
        catch (Exception | NoClassDefFoundError throwable) {
            return 0;
        }
    }

    public void takeCurrency(Player player, Category category) {
        this.takeCurrency(player, category.getCurrency(), category.getCost());
    }

    public void takeCurrency(Player player, LostBook lostBook) {
        this.takeCurrency(player, lostBook.getCurrency(), lostBook.getCost());
    }

    public void takeCurrency(Player player, ShopOption option) {
        this.takeCurrency(player, option.getCurrency(), option.getCost());
    }

    public void takeCurrency(Player player, Currency currency, int amount) {
        try {
            switch (currency) {
                case VAULT: {
                    this.starter.getVaultSupport().getVault().withdrawPlayer((OfflinePlayer)player, (double)amount);
                    break;
                }
                case XP_LEVEL: {
                    player.setLevel(player.getLevel() - amount);
                    break;
                }
                case XP_TOTAL: {
                    this.takeTotalExperience(player, amount);
                }
            }
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    public void giveCurrency(Player player, Currency currency, int amount) {
        try {
            switch (currency) {
                case VAULT: {
                    this.starter.getVaultSupport().getVault().depositPlayer((OfflinePlayer)player, (double)amount);
                    break;
                }
                case XP_LEVEL: {
                    player.setLevel(player.getLevel() + amount);
                    break;
                }
                case XP_TOTAL: {
                    this.takeTotalExperience(player, -amount);
                }
            }
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    public boolean canBuy(Player player, Category category) {
        return this.canBuy(player, category.getCurrency(), category.getCost());
    }

    public boolean canBuy(Player player, LostBook lostBook) {
        return this.canBuy(player, lostBook.getCurrency(), lostBook.getCost());
    }

    public boolean canBuy(Player player, ShopOption option) {
        return this.canBuy(player, option.getCurrency(), option.getCost());
    }

    public boolean canBuy(Player player, Currency currency, int cost) {
        return this.getCurrency(player, currency) >= cost;
    }

    private void takeTotalExperience(Player player, int amount) {
        int total;
        player.setTotalExperience(0);
        player.setTotalExperience(total);
        player.setLevel(0);
        player.setExp(0.0f);
        for (total = this.getTotalExperience(player) - amount; total > player.getExpToLevel(); total -= player.getExpToLevel()) {
            player.setLevel(player.getLevel() + 1);
        }
        float xp = (float)total / (float)player.getExpToLevel();
        player.setExp(xp);
    }

    private int getTotalExperience(Player player) {
        int level = player.getLevel();
        if (level >= 0 && level <= 15) {
            int experience = (int)Math.ceil(Math.pow(level, 2.0) + (double)(6 * level));
            int requiredExperience = 2 * level + 7;
            double currentExp = Double.parseDouble(Float.toString(player.getExp()));
            return experience += (int)Math.ceil(currentExp * (double)requiredExperience);
        }
        if (level > 15 && level <= 30) {
            int experience = (int)Math.ceil(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
            int requiredExperience = 5 * level - 38;
            double currentExp = Double.parseDouble(Float.toString(player.getExp()));
            return experience += (int)Math.ceil(currentExp * (double)requiredExperience);
        }
        int experience = (int)Math.ceil(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        int requiredExperience = 9 * level - 158;
        double currentExp = Double.parseDouble(Float.toString(player.getExp()));
        return experience += (int)Math.ceil(currentExp * (double)requiredExperience);
    }

    public void loadCurrency() {
        for (PluginSupport.SupportedPlugins supportedPlugin : PluginSupport.SupportedPlugins.values()) {
            if (!supportedPlugin.isPluginLoaded() || !supportedPlugin.getLoadedPlugin().isEnabled()) continue;
            if (supportedPlugin == PluginSupport.SupportedPlugins.VAULT) {
                this.starter.setVaultSupport(new VaultSupport());
            }
            return;
        }
        this.plugin.getLogger().warning("No eco plugin found or the eco plugin didn't enable. Any economy based feature will not work.");
    }
}

