/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.builders.types.tinkerer;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.InventoryBuilder;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.builders.types.tinkerer.TinkererManager;
import com.badbones69.crazyenchantments.paper.api.economy.Currency;
import com.badbones69.crazyenchantments.paper.api.economy.CurrencyAPI;
import com.badbones69.crazyenchantments.paper.api.enums.Dust;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.objects.CEBook;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.List;
import java.util.Map;
import libs.com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class TinkererMenu
extends InventoryBuilder {
    private final FileConfiguration configuration = FileManager.Files.TINKER.getFile();

    public TinkererMenu(Player player, int size, String title) {
        super(player, size, title);
    }

    @Override
    public InventoryBuilder build() {
        ItemStack button = new ItemBuilder().setMaterial(this.configuration.getString("Settings.TradeButton-Type", "RED_STAINED_GLASS_PANE")).setName(this.configuration.getString("Settings.TradeButton", "&eClick to accept the trade")).setLore(this.configuration.getStringList("Settings.TradeButton-Lore")).setItemModel(this.configuration.getString("Settings.TradeButton-Model.Namespace", ""), this.configuration.getString("Settings.TradeButton-Model.Key", "")).addKey(DataKeys.trade_button.getNamespacedKey(), "").build();
        this.getInventory().setItem(0, button);
        this.getInventory().setItem(8, button);
        ItemStack divider = new ItemBuilder().setMaterial(Material.WHITE_STAINED_GLASS_PANE).setName(" ").build();
        List.of(Integer.valueOf(4), Integer.valueOf(13), Integer.valueOf(22), Integer.valueOf(31), Integer.valueOf(40), Integer.valueOf(49)).forEach(slot -> this.getInventory().setItem(slot.intValue(), divider));
        return this;
    }

    public static class TinkererListener
    implements Listener {
        private final FileConfiguration configuration = FileManager.Files.TINKER.getFile();
        @NotNull
        private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
        private final CurrencyAPI api = this.plugin.getStarter().getCurrencyAPI();
        private final Map<Integer, Integer> slots = TinkererManager.getSlots();
        @NotNull
        private final EnchantmentBookSettings enchantmentBookSettings = this.plugin.getStarter().getEnchantmentBookSettings();

        @EventHandler
        public void onExperienceUse(PlayerInteractEvent event) {
            if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            Player player = event.getPlayer();
            if (TinkererManager.useExperience(player, event, true, this.configuration)) {
                return;
            }
            TinkererManager.useExperience(player, event, false, this.configuration);
        }

        @EventHandler(ignoreCancelled=true)
        public void onInventoryClick(InventoryClickEvent event) {
            InventoryHolder inventoryHolder = event.getInventory().getHolder();
            if (!(inventoryHolder instanceof TinkererMenu)) {
                return;
            }
            TinkererMenu holder = (TinkererMenu)inventoryHolder;
            Player player = holder.getPlayer();
            event.setCancelled(true);
            ItemStack current = event.getCurrentItem();
            if (current == null || current.isEmpty()) {
                return;
            }
            Inventory inventory = holder.getInventory();
            Inventory topInventory = player.getOpenInventory().getTopInventory();
            Inventory bottomInventory = player.getOpenInventory().getBottomInventory();
            if (current.getPersistentDataContainer().has(DataKeys.trade_button.getNamespacedKey())) {
                int total = 0;
                boolean toggle = false;
                Currency currency = Currency.getCurrency(this.configuration.getString("Settings.Currency", "Vault"));
                for (Map.Entry<Integer, Integer> slot : this.slots.entrySet()) {
                    ItemStack reward = inventory.getItem(slot.getValue().intValue());
                    if (reward != null) {
                        if (currency == Currency.VAULT) {
                            total = TinkererManager.getTotalXP(inventory.getItem(slot.getKey().intValue()), this.configuration);
                        } else {
                            bottomInventory.addItem(new ItemStack[]{reward}).values().forEach(item -> player.getWorld().dropItem(player.getLocation(), item));
                        }
                        toggle = true;
                    }
                    inventory.setItem(slot.getKey().intValue(), null);
                    inventory.setItem(slot.getValue().intValue(), null);
                }
                player.closeInventory();
                if (total != 0) {
                    this.api.giveCurrency(player, currency, total);
                }
                if (toggle) {
                    player.sendMessage(Messages.TINKER_SOLD_MESSAGE.getMessage());
                }
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_YES, 1.0f, 1.0f);
                return;
            }
            if (current.getType().toString().endsWith("STAINED_GLASS_PANE")) {
                return;
            }
            if (this.enchantmentBookSettings.isEnchantmentBook(current)) {
                CEBook book = this.enchantmentBookSettings.getCEBook(current);
                if (book == null) {
                    return;
                }
                if (event.getClickedInventory() == topInventory) {
                    event.setCurrentItem(null);
                    bottomInventory.addItem(new ItemStack[]{current});
                    inventory.setItem(this.slots.get(event.getRawSlot()).intValue(), null);
                } else {
                    if (this.isFirstEmpty(event, player, current, topInventory)) {
                        return;
                    }
                    inventory.setItem(this.slots.get(inventory.firstEmpty()).intValue(), Dust.MYSTERY_DUST.getDust(TinkererManager.getMaxDustLevelFromBook(book, this.configuration), 1));
                    inventory.setItem(inventory.firstEmpty(), current);
                }
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                return;
            }
            int totalXP = TinkererManager.getTotalXP(current, this.configuration);
            if (totalXP > 0) {
                if (event.getClickedInventory() == topInventory) {
                    if (this.slots.containsKey(event.getRawSlot())) {
                        event.setCurrentItem(null);
                        player.getInventory().addItem(new ItemStack[]{current});
                        inventory.setItem(this.slots.get(event.getRawSlot()).intValue(), null);
                    }
                } else {
                    if (this.isFirstEmpty(event, player, current, topInventory)) {
                        return;
                    }
                    inventory.setItem(this.slots.get(inventory.firstEmpty()).intValue(), TinkererManager.getXPBottle(String.valueOf(totalXP), this.configuration));
                    inventory.setItem(inventory.firstEmpty(), current);
                }
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        }

        private boolean isFirstEmpty(InventoryClickEvent event, Player player, ItemStack current, Inventory topInventory) {
            if (topInventory.firstEmpty() == -1) {
                player.sendMessage(Messages.TINKER_INVENTORY_FULL.getMessage());
                return true;
            }
            if (current.getAmount() > 1) {
                player.sendMessage(Messages.NEED_TO_UNSTACK_ITEM.getMessage());
                return true;
            }
            event.setCurrentItem(null);
            return false;
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onInvClose(InventoryCloseEvent event) {
            InventoryHolder inventoryHolder = event.getInventory().getHolder();
            if (!(inventoryHolder instanceof TinkererMenu)) {
                return;
            }
            final TinkererMenu holder = (TinkererMenu)inventoryHolder;
            final Player player = holder.getPlayer();
            new FoliaScheduler(this.plugin, null, (Entity)player){

                @Override
                public void run() {
                    Inventory inventory = holder.getInventory();
                    for (int slot : slots.keySet()) {
                        ItemStack item = inventory.getItem(slot);
                        if (item == null || item.isEmpty()) continue;
                        if (player.isDead()) {
                            player.getWorld().dropItem(player.getLocation(), item);
                            continue;
                        }
                        player.getInventory().addItem(new ItemStack[]{item}).values().forEach(item2 -> player.getWorld().dropItem(player.getLocation(), item2));
                    }
                    holder.getInventory().clear();
                }
            }.execute();
        }
    }
}

