/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.builders.types.blacksmith;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.builders.InventoryBuilder;
import com.badbones69.crazyenchantments.paper.api.builders.types.blacksmith.BlackSmithManager;
import com.badbones69.crazyenchantments.paper.api.economy.Currency;
import com.badbones69.crazyenchantments.paper.api.economy.CurrencyAPI;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.api.objects.BlackSmithResult;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.Arrays;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BlackSmithMenu
extends InventoryBuilder {
    public BlackSmithMenu(Player player, int size, String title) {
        super(player, size, title);
    }

    @Override
    public InventoryBuilder build() {
        Inventory inventory = this.getInventory();
        for (int slot : new int[]{0, 7, 8, 9, 16, 18, 25, 26}) {
            inventory.setItem(slot, BlackSmithManager.getGrayGlass());
        }
        for (int slot : new int[]{1, 2, 3, 4, 5, 6, 10, 12, 13, 15, 19, 20, 21, 22, 23, 24}) {
            inventory.setItem(slot, BlackSmithManager.getRedGlass());
        }
        inventory.setItem(17, BlackSmithManager.getExitButton());
        return this;
    }

    public static class BlackSmithListener
    implements Listener {
        private final Sound click = Sound.UI_BUTTON_CLICK;
        private final Sound levelUp = Sound.ENTITY_PLAYER_LEVELUP;
        private final Sound villagerNo = Sound.ENTITY_VILLAGER_NO;
        private final List<Integer> resultBorder = Arrays.asList(0, 7, 8, 9, 16, 18, 25, 26);
        private final int mainSlot = 11;
        private final int subSlot = 14;
        private final int outputSlot = 17;
        @NotNull
        private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
        @NotNull
        private final Starter starter = this.plugin.getStarter();
        @NotNull
        private final Methods methods = this.starter.getMethods();
        @NotNull
        private final EnchantmentBookSettings settings = this.starter.getEnchantmentBookSettings();

        @EventHandler(ignoreCancelled=true)
        public void onInventoryClick(InventoryClickEvent event) {
            InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
            if (!(inventoryHolder instanceof BlackSmithMenu)) {
                return;
            }
            BlackSmithMenu holder = (BlackSmithMenu)inventoryHolder;
            Inventory inventory = holder.getInventory();
            InventoryView view = holder.getInventoryView();
            event.setCancelled(true);
            ItemStack item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            Player player = holder.getPlayer();
            if (event.getClickedInventory() != view.getTopInventory()) {
                if (item.getAmount() != 1) {
                    return;
                }
                if (!this.settings.getEnchantments(item).isEmpty() || this.settings.isEnchantmentBook(item)) {
                    if (inventory.getItem(this.mainSlot) == null) {
                        event.setCurrentItem(null);
                        inventory.setItem(this.mainSlot, item);
                        this.playSound(player, this.click);
                        if (inventory.getItem(this.subSlot) != null) {
                            BlackSmithResult resultItem = new BlackSmithResult(player, inventory.getItem(this.mainSlot), inventory.getItem(this.subSlot));
                            this.setBorder(resultItem, inventory);
                        }
                    } else {
                        event.setCurrentItem(null);
                        if (inventory.getItem(14) != null) {
                            event.setCurrentItem(inventory.getItem(this.subSlot));
                        }
                        inventory.setItem(this.subSlot, item);
                        this.playSound(player, this.click);
                        BlackSmithResult resultItem = new BlackSmithResult(player, inventory.getItem(this.mainSlot), inventory.getItem(this.subSlot));
                        this.setBorder(resultItem, inventory);
                    }
                }
            } else {
                if (event.getRawSlot() == this.mainSlot || event.getRawSlot() == this.subSlot) {
                    event.setCurrentItem(null);
                    this.methods.addItemToInventory(player, item);
                    inventory.setItem(17, BlackSmithManager.getExitButton());
                    this.resultBorder.forEach(slot -> inventory.setItem(slot.intValue(), BlackSmithManager.getRedGlass()));
                    this.playSound(player, this.click);
                }
                if (event.getRawSlot() == this.outputSlot) {
                    if (inventory.getItem(this.mainSlot) != null && inventory.getItem(this.subSlot) != null) {
                        BlackSmithResult result = new BlackSmithResult(player, inventory.getItem(this.mainSlot), inventory.getItem(this.subSlot));
                        if (result.getCost() > 0) {
                            Currency currency = BlackSmithManager.getCurrency();
                            if (currency != null && player.getGameMode() != GameMode.CREATIVE) {
                                CurrencyAPI currencyAPI = this.plugin.getStarter().getCurrencyAPI();
                                if (currencyAPI.canBuy(player, currency, result.getCost())) {
                                    currencyAPI.takeCurrency(player, currency, result.getCost());
                                } else {
                                    String needed = String.valueOf(result.getCost() - currencyAPI.getCurrency(player, currency));
                                    this.methods.switchCurrency(player, currency, "%Money_Needed%", "%XP%", needed);
                                    return;
                                }
                            }
                            this.methods.addItemToInventory(player, result.getResultItem());
                            inventory.setItem(this.mainSlot, null);
                            inventory.setItem(this.subSlot, null);
                            this.playSound(player, this.levelUp);
                            inventory.setItem(this.outputSlot, BlackSmithManager.getExitButton());
                            for (int slot2 : this.resultBorder) {
                                inventory.setItem(slot2, BlackSmithManager.getRedGlass());
                            }
                            return;
                        }
                        this.playSound(player, this.villagerNo);
                        return;
                    }
                    this.playSound(player, this.villagerNo);
                }
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onInventoryClose(InventoryCloseEvent event) {
            InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
            if (!(inventoryHolder instanceof BlackSmithMenu)) {
                return;
            }
            BlackSmithMenu holder = (BlackSmithMenu)inventoryHolder;
            Player player = holder.getPlayer();
            for (int slot : new int[]{this.mainSlot, this.subSlot}) {
                ItemStack itemStack = holder.getInventory().getItem(slot);
                if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                this.methods.addItemToInventory(player, itemStack);
            }
            holder.getInventory().clear();
        }

        private void setBorder(BlackSmithResult item, Inventory inventory) {
            if (item.getCost() > 0) {
                ItemStack result = item.getResultItem();
                String value = String.valueOf(item.getCost());
                String message = Messages.replacePlaceholders("%Cost%", value, BlackSmithManager.getItemCost());
                for (int slot : this.resultBorder) {
                    inventory.setItem(slot, BlackSmithManager.getBlueGlass());
                }
                inventory.setItem(this.outputSlot, this.methods.addLore(result, message));
            } else {
                inventory.setItem(this.outputSlot, BlackSmithManager.getExitButton());
                for (int slot : this.resultBorder) {
                    inventory.setItem(slot, BlackSmithManager.getRedGlass());
                }
            }
        }

        private void playSound(Player player, Sound sound) {
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
    }
}

