/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import libs.com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import libs.com.ryderbelserion.fusion.paper.scheduler.Scheduler;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class FileManager {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final HashMap<Files, File> files = new HashMap();
    private final List<String> homeFolders = new ArrayList<String>();
    private final List<CustomFile> customFiles = new ArrayList<CustomFile>();
    private final HashMap<String, String> jarHomeFolders = new HashMap();
    private final HashMap<String, String> autoGenerateFiles = new HashMap();
    private final HashMap<Files, FileConfiguration> configurations = new HashMap();

    public void setup() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.files.clear();
        this.customFiles.clear();
        this.configurations.clear();
        for (Files file : Files.values()) {
            String[] newFile = new File(this.plugin.getDataFolder(), file.getFileLocation());
            if (this.plugin.isLogging()) {
                this.plugin.getLogger().info("Loading the " + file.getFileName());
            }
            if (!newFile.exists()) {
                try (InputStream jarFile = this.getClass().getResourceAsStream("/" + file.getFileJar());){
                    File serverFile = new File(this.plugin.getDataFolder(), "/" + file.getFileLocation());
                    this.copyFile(jarFile, serverFile);
                }
                catch (Exception exception) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to load file: " + file.getFileName(), exception);
                    continue;
                }
            }
            this.files.put(file, (File)newFile);
            if (file.getFileName().endsWith(".yml")) {
                this.configurations.put(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)newFile));
            }
            if (!this.plugin.isLogging()) continue;
            this.plugin.getLogger().info("Successfully loaded " + file.getFileName());
        }
        if (!this.homeFolders.isEmpty()) {
            if (this.plugin.isLogging()) {
                this.plugin.getLogger().info("Loading custom files.");
            }
            for (String homeFolder : this.homeFolders) {
                File homeFile = new File(this.plugin.getDataFolder(), "/" + homeFolder);
                if (homeFile.exists()) {
                    String[] list = homeFile.list();
                    if (list == null) continue;
                    for (String name : list) {
                        CustomFile file;
                        if (!name.endsWith(".yml") || !(file = new CustomFile(name, homeFolder)).exists()) continue;
                        this.customFiles.add(file);
                        if (!this.plugin.isLogging()) continue;
                        this.plugin.getLogger().info("Loaded new custom file: " + homeFolder + "/" + name + ".");
                    }
                    continue;
                }
                homeFile.mkdir();
                if (this.plugin.isLogging()) {
                    this.plugin.getLogger().info("The folder " + homeFolder + "/ was not found so it was created.");
                }
                for (Map.Entry<String, String> fileName : this.autoGenerateFiles.entrySet()) {
                    if (!this.autoGenerateFiles.get(fileName.getKey()).equalsIgnoreCase(homeFolder)) continue;
                    homeFolder = fileName.getValue();
                    try {
                        InputStream jarFile = this.getClass().getResourceAsStream(this.jarHomeFolders.getOrDefault(fileName.getKey(), homeFolder) + "/" + fileName.getKey());
                        try {
                            File serverFile = new File(this.plugin.getDataFolder(), homeFolder + "/" + fileName.getKey());
                            this.copyFile(jarFile, serverFile);
                            if (fileName.getKey().toLowerCase().endsWith(".yml")) {
                                this.customFiles.add(new CustomFile(fileName.getKey(), homeFolder));
                            }
                            if (!this.plugin.isLogging()) continue;
                            this.plugin.getLogger().info("Created new default file: " + homeFolder + "/" + fileName.getKey() + ".");
                        }
                        finally {
                            if (jarFile == null) continue;
                            jarFile.close();
                        }
                    }
                    catch (Exception exception) {
                        this.plugin.getLogger().log(Level.SEVERE, "Failed to create new default file: " + homeFolder + "/" + fileName.getKey() + "!", exception);
                    }
                }
            }
            if (this.plugin.isLogging()) {
                this.plugin.getLogger().info("Finished loading custom files.");
            }
        }
    }

    public FileManager registerCustomFilesFolder(String homeFolder) {
        this.homeFolders.add(homeFolder);
        return this;
    }

    public FileManager unregisterCustomFilesFolder(String homeFolder) {
        this.homeFolders.remove(homeFolder);
        return this;
    }

    public FileManager registerDefaultGenerateFiles(String fileName, String homeFolder) {
        this.autoGenerateFiles.put(fileName, homeFolder);
        return this;
    }

    public FileManager registerDefaultGenerateFiles(String fileName, String homeFolder, String jarHomeFolder) {
        this.autoGenerateFiles.put(fileName, homeFolder);
        this.jarHomeFolders.put(fileName, jarHomeFolder);
        return this;
    }

    public FileManager unregisterDefaultGenerateFiles(String fileName) {
        this.autoGenerateFiles.remove(fileName);
        this.jarHomeFolders.remove(fileName);
        return this;
    }

    public FileConfiguration getFile(Files file) {
        return this.configurations.get((Object)file);
    }

    public CustomFile getFile(String name) {
        for (CustomFile file : this.customFiles) {
            if (!file.getName().equalsIgnoreCase(name)) continue;
            return file;
        }
        return null;
    }

    public void removeFile(String name) {
        this.customFiles.remove(this.getFile(name));
    }

    public void addFile(String name, String folder) {
        this.customFiles.add(new CustomFile(name, folder));
    }

    public void saveFile(final Files file) {
        new FoliaScheduler(this.plugin, Scheduler.global_scheduler){

            @Override
            public void run() {
                try {
                    FileManager.this.configurations.get((Object)file).save(FileManager.this.files.get((Object)file));
                }
                catch (IOException exception) {
                    FileManager.this.plugin.getLogger().log(Level.SEVERE, "Could not save " + file.getFileName() + "!", exception);
                }
            }
        }.runNow();
    }

    public void saveFile(String name) {
        CustomFile file = this.getFile(name);
        if (file == null) {
            if (this.plugin.isLogging()) {
                this.plugin.getLogger().warning("The file " + name + ".yml could not be found!");
            }
            return;
        }
        try {
            file.getFile().save(new File(this.plugin.getDataFolder(), file.getHomeFolder() + "/" + file.getFileName()));
            if (this.plugin.isLogging()) {
                this.plugin.getLogger().info("Successfully saved the " + file.getFileName() + ".");
            }
        }
        catch (Exception exception) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save " + file.getFileName() + "!", exception);
        }
    }

    public void saveFile(CustomFile file) {
        file.saveFile();
    }

    public void reloadFile(Files file) {
        if (file.getFileName().endsWith(".yml")) {
            this.configurations.put(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)this.files.get((Object)file)));
        }
    }

    public void reloadFile(String name) {
        CustomFile file = this.getFile(name);
        if (file != null) {
            try {
                file.file = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "/" + file.getHomeFolder() + "/" + file.getFileName()));
                if (this.plugin.isLogging()) {
                    this.plugin.getLogger().info("Successfully reloaded the " + file.getFileName() + ".");
                }
            }
            catch (Exception exception) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not reload the " + file.getFileName() + "!", exception);
            }
        } else if (this.plugin.isLogging()) {
            this.plugin.getLogger().warning("The file " + name + ".yml could not be found!");
        }
    }

    public void reloadFile(CustomFile file) {
        file.reloadFile();
    }

    public void reloadAllFiles() {
        for (Files file : Files.values()) {
            file.reloadFile();
        }
        for (CustomFile file : this.customFiles) {
            file.reloadFile();
        }
    }

    public List<String> getAllCratesNames() {
        ArrayList<String> files = new ArrayList<String>();
        String[] file = new File(this.plugin.getDataFolder(), "/crates").list();
        if (file != null) {
            for (String name : file) {
                if (!name.endsWith(".yml")) continue;
                files.add(name.replaceAll(".yml", ""));
            }
        }
        return files;
    }

    private void copyFile(InputStream in, File out) throws Exception {
        try (InputStream fis = in;
             FileOutputStream fos = new FileOutputStream(out);){
            int i;
            byte[] buf = new byte[1024];
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
    }

    public static enum Files {
        CONFIG("config.yml", "config.yml"),
        BLOCKLIST("BlockList.yml", "BlockList.yml"),
        HEADMAP("HeadMap.yml", "HeadMap.yml"),
        DATA("Data.yml", "Data.yml"),
        ENCHANTMENTS("Enchantments.yml", "Enchantments.yml"),
        GKITZ("GKitz.yml", "GKitz.yml"),
        MESSAGES("Messages.yml", "Messages.yml"),
        ENCHANTMENT_TYPES("Enchantment-Types.yml", "Enchantment-Types.yml"),
        TINKER("Tinker.yml", "Tinker.yml");

        private final String fileName;
        private final String fileJar;
        private final String fileLocation;
        @NotNull
        private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
        @NotNull
        private final FileManager fileManager = this.plugin.getStarter().getFileManager();

        private Files(String fileName, String fileLocation) {
            this(fileName, fileLocation, fileLocation);
        }

        private Files(String fileName, String fileLocation, String fileJar) {
            this.fileName = fileName;
            this.fileLocation = fileLocation;
            this.fileJar = fileJar;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileLocation() {
            return this.fileLocation;
        }

        public String getFileJar() {
            return this.fileJar;
        }

        public FileConfiguration getFile() {
            return this.fileManager.getFile(this);
        }

        public void saveFile() {
            this.fileManager.saveFile(this);
        }

        public void reloadFile() {
            if (this.getFileName().endsWith(".yml")) {
                this.fileManager.reloadFile(this);
            }
        }
    }

    public static class CustomFile {
        private final String name;
        private final String fileName;
        private final String homeFolder;
        private FileConfiguration file;
        @NotNull
        private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);

        public CustomFile(String name, String homeFolder) {
            this.name = name.replace(".yml", "");
            this.fileName = name;
            this.homeFolder = homeFolder;
            if (new File(this.plugin.getDataFolder(), "/" + homeFolder).exists()) {
                this.file = new File(this.plugin.getDataFolder(), "/" + homeFolder + "/" + name).exists() ? YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "/" + homeFolder + "/" + name)) : null;
            } else {
                new File(this.plugin.getDataFolder(), "/" + homeFolder).mkdir();
                if (this.plugin.isLogging()) {
                    this.plugin.getLogger().info("The folder " + homeFolder + "/ was not found so it was created.");
                }
                this.file = null;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getHomeFolder() {
            return this.homeFolder;
        }

        public FileConfiguration getFile() {
            return this.file;
        }

        public boolean exists() {
            return this.file != null;
        }

        public void saveFile() {
            if (this.file != null) {
                try {
                    this.file.save(new File(this.plugin.getDataFolder(), this.homeFolder + "/" + this.fileName));
                    if (this.plugin.isLogging()) {
                        this.plugin.getLogger().info("Successfully saved the " + this.fileName + ".");
                    }
                }
                catch (Exception exception) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not save " + this.fileName + "!", exception);
                }
            } else if (this.plugin.isLogging()) {
                this.plugin.getLogger().warning("There was a null custom file that could not be found!");
            }
        }

        public void reloadFile() {
            if (this.file != null) {
                try {
                    this.file = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "/" + this.homeFolder + "/" + this.fileName));
                    if (this.plugin.isLogging()) {
                        this.plugin.getLogger().info("Successfully reloaded the " + this.fileName + ".");
                    }
                }
                catch (Exception exception) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not reload the " + this.fileName + "!", exception);
                }
            } else if (this.plugin.isLogging()) {
                this.plugin.getLogger().warning("There was a null custom file that was not found!");
            }
        }
    }
}

