/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.numbers;

import java.util.Optional;

public enum ValueRangeComparison {
    WITHIN_RANGE,
    BELOW_MINIMUM,
    ABOVE_MAXIMUM,
    UNSUPPORTED_POSITIVE_INFINITY,
    UNSUPPORTED_NEGATIVE_INFINITY,
    UNSUPPORTED_NAN;


    public static Optional<ValueRangeComparison> getErrorForNonFiniteValue(Number number) {
        if (number instanceof Double || number instanceof Float) {
            return ValueRangeComparison.getErrorForNonFiniteValue(number.doubleValue());
        }
        return Optional.empty();
    }

    public static Optional<ValueRangeComparison> getErrorForNonFiniteValue(double value) {
        if (Double.isFinite(value)) {
            return Optional.empty();
        }
        if (value == Double.POSITIVE_INFINITY) {
            return Optional.of(UNSUPPORTED_POSITIVE_INFINITY);
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return Optional.of(UNSUPPORTED_NEGATIVE_INFINITY);
        }
        return Optional.of(UNSUPPORTED_NAN);
    }

    public boolean isTooSmall() {
        return this == BELOW_MINIMUM || this == UNSUPPORTED_NEGATIVE_INFINITY;
    }

    public boolean isTooLarge() {
        return this == ABOVE_MAXIMUM || this == UNSUPPORTED_POSITIVE_INFINITY;
    }

    public boolean isUnsupportedInfinity() {
        return this == UNSUPPORTED_POSITIVE_INFINITY || this == UNSUPPORTED_NEGATIVE_INFINITY;
    }

    public boolean isUnsupportedNonFiniteValue() {
        return this.isUnsupportedInfinity() || this == UNSUPPORTED_NAN;
    }
}

