/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.numbers;

import ch.jalu.typeresolver.numbers.NumberTypes;
import ch.jalu.typeresolver.numbers.StandardNumberType;
import ch.jalu.typeresolver.numbers.ValueRange;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public enum StandardValueRange implements ValueRange
{
    BYTE((byte)-128, (byte)127, v -> BigDecimal.valueOf(v.byteValue())),
    SHORT((short)Short.MIN_VALUE, (short)Short.MAX_VALUE, v -> BigDecimal.valueOf(v.shortValue())),
    INTEGER(Integer.MIN_VALUE, Integer.MAX_VALUE, v -> BigDecimal.valueOf(v.intValue())),
    LONG(Long.MIN_VALUE, Long.MAX_VALUE, v -> BigDecimal.valueOf(v)),
    FLOAT(Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE), v -> BigDecimal.valueOf(v.floatValue())),
    DOUBLE(-1.7976931348623157E308, Double.MAX_VALUE, v -> BigDecimal.valueOf(v)),
    BIG_INTEGER,
    BIG_DECIMAL;

    private final Number minInOwnType;
    private final BigDecimal min;
    private final Number maxInOwnType;
    private final BigDecimal max;

    private <T extends Number> StandardValueRange(T min, T max, Function<T, BigDecimal> toBigDecimal) {
        this.minInOwnType = min;
        this.min = toBigDecimal.apply(min);
        this.maxInOwnType = max;
        this.max = toBigDecimal.apply(max);
    }

    private StandardValueRange() {
        this.minInOwnType = null;
        this.min = null;
        this.maxInOwnType = null;
        this.max = null;
    }

    public static StandardValueRange findRangeOrThrow(Number number) {
        Class<?> nrClass = NumberTypes.unwrapToStandardNumberType(number).getClass();
        StandardNumberType enumFromClass = StandardNumberType.fromClass(nrClass);
        if (enumFromClass != null) {
            return (StandardValueRange)enumFromClass.getValueRange();
        }
        if (number instanceof BigInteger) {
            return BIG_INTEGER;
        }
        if (number instanceof BigDecimal) {
            return BIG_DECIMAL;
        }
        throw new IllegalArgumentException("Unsupported number type: " + number.getClass());
    }

    @Override
    public boolean supportsDecimals() {
        switch (this) {
            case FLOAT: 
            case DOUBLE: 
            case BIG_DECIMAL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasInfinityAndNaN() {
        switch (this) {
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsAllValuesOf(StandardValueRange other) {
        return ValueRange.super.supportsAllValuesOf(other);
    }

    public String toString() {
        return "StandardValueRange[" + this.name() + "]";
    }

    @Override
    @Nullable
    public BigDecimal getMinValue() {
        return this.min;
    }

    @Override
    @Nullable
    public BigDecimal getMaxValue() {
        return this.max;
    }

    @Nullable
    public Number getMinInOwnType() {
        return this.minInOwnType;
    }

    @Nullable
    public Number getMaxInOwnType() {
        return this.maxInOwnType;
    }
}

